/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.conf.ConfSet;
import ebuild.core.BuildPlan;
import ebuild.core.CPart;
import ebuild.core.ComponentBuildPlan;
import ebuild.core.ComponentCPart;
import ebuild.core.ComponentProjectHelper;
import ebuild.core.EBuild;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildRunner;
import ebuild.core.EKey;
import ebuild.core.ElementNature;
import ebuild.core.Part;
import ebuild.util.NameTemplate;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Part<ComponentXml.EbuildComponent> {
    private NameTemplate templateOutput;
    private NameTemplate templateSource;

    public Component(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
    }

    @Override
    public void initDeclaration(ComponentXml.EbuildComponent declaration) throws EBuildException {
        super.initDeclaration(declaration);
        this.templateOutput = this.nameTemplateOfOutput();
        this.templateSource = this.nameTemplateOfSource();
    }

    @Override
    CPart newCPart(ConfSet conf, ConfSet confSelected) {
        return new ComponentCPart(this, conf, confSelected);
    }

    @Override
    BuildPlan newBuildPlan(EBuildRunner runner, ConfSet confSet, ILogger logger) throws EBuildException {
        return new ComponentBuildPlan(runner, logger, this, confSet);
    }

    @Override
    public ComponentProjectHelper newProjectHelper() throws EBuildException {
        return new ComponentProjectHelper(this);
    }

    @Override
    public ComponentProjectHelper getProjectHelper() {
        return (ComponentProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.component;
    }

    public Map<String, ? extends Iterable<ComponentXml.Include>> getModuleSelectionXml(final ConfSet conf) throws EBuildException {
        final HashMap r = new HashMap();
        ComponentProjectHelper componentProjectHelper = this.getProjectHelper();
        componentProjectHelper.getClass();
        new ComponentProjectHelper.AssemblyVisitor(componentProjectHelper, conf){
            {
                ComponentProjectHelper componentProjectHelper = x0;
                componentProjectHelper.getClass();
                super(componentProjectHelper, x1);
            }

            public void visitModuleSelection(String path, ComponentXml.ModuleSelection moduleSelection) {
                List<ComponentXml.Include> l = moduleSelection.includes;
                ComponentXml.OurModule ours = moduleSelection.ourModule;
                if (ours != null) {
                    ComponentXml.Include inc = new ComponentXml.Include();
                    inc.source = "local";
                    inc.org = Component.this.key.org;
                    inc.name = Component.this.key.name;
                    inc.confs = conf.toString();
                    inc.revision = Component.this.key.version.getRevision();
                    inc.branch = Component.this.key.version.getBranch();
                    inc.version = Component.this.key.version.getTag();
                    inc.dependencies = ours.dependencies;
                    ArrayList<ComponentXml.Include> l2 = new ArrayList<ComponentXml.Include>(l.size() + 1);
                    l2.addAll(l);
                    l2.add(inc);
                    l = l2;
                }
                r.put(path, l);
            }
        }.go();
        return r;
    }

    public Map<String, Xml.SelectAndMap> getSelectedComponentsXml(ConfSet conf) throws EBuildException {
        final HashMap<String, Xml.SelectAndMap> r = new HashMap<String, Xml.SelectAndMap>();
        ComponentProjectHelper componentProjectHelper = this.getProjectHelper();
        componentProjectHelper.getClass();
        new ComponentProjectHelper.AssemblyVisitor(componentProjectHelper, conf){
            {
                ComponentProjectHelper componentProjectHelper = x0;
                componentProjectHelper.getClass();
                super(componentProjectHelper, x1);
            }

            void visitComponent(String path, Xml.SelectAndMap component) {
                r.put(path, component);
            }
        }.go();
        return r;
    }

    public String releaseSourceFileName() {
        String r = this.getNameTemplateOfSource().apply(new NameTemplate.Model(){

            public String getValue(String varname) {
                if ("version".equals(varname)) {
                    return Component.this.key.version + "";
                }
                return null;
            }
        });
        return r;
    }

    public NameTemplate getNameTemplateOfOutput() {
        return this.templateOutput;
    }

    public NameTemplate getNameTemplateOfSource() {
        return this.templateSource;
    }

    private NameTemplate nameTemplateBase() throws EBuildException {
        NameTemplate r;
        String name = ((ComponentXml.EbuildComponent)this.getDeclaration()).release.name;
        if (name == null) {
            name = this.getName();
        }
        if (!(r = NameTemplate.parse(name)).hasVar("version")) {
            r.appendVar("-", "version");
        }
        return r;
    }

    private NameTemplate nameTemplateOfOutput() throws EBuildException {
        String suffix;
        NameTemplate r = this.nameTemplateBase();
        if (!r.hasVar("confs")) {
            r.appendVar("-", "confs");
        }
        if ((suffix = ((ComponentXml.EbuildComponent)this.getDeclaration()).release.suffix) != null) {
            NameTemplate s = NameTemplate.parse("." + suffix);
            r.append(s);
        }
        return r;
    }

    private NameTemplate nameTemplateOfSource() throws EBuildException {
        return this.nameTemplateBase();
    }
}

