/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.conf.ConfMapping;
import ebuild.conf.ConfSet;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.CEKey;
import ebuild.core.CPart;
import ebuild.core.Component;
import ebuild.core.ComponentCDependencies;
import ebuild.core.ComponentProjectHelper;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildException;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.Task;
import ebuild.util.CollectionUtil;
import ebuild.util.tuple.Pair;
import ebuild.util.tuple.Triple;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuildPlan
extends BuildPlan {
    final Component component;
    final EBuildContext context;
    final ConfSet conf_plan;
    private final CPart cpart;
    private final Map<String, BuildPlan> subPlans = new LinkedHashMap<String, BuildPlan>();

    public ComponentBuildPlan(EBuildRunner runner, ILogger logger, Component component, ConfSet confs) throws EBuildException {
        super(runner, logger, new CEKey(component.key, confs));
        this.component = component;
        this.context = component.getProjectHelper().context;
        this.cpart = component.getCPart(confs);
        this.conf_plan = confs;
    }

    public Collection<CEKey> getSubject() {
        return CollectionUtil.singletonSet(this.getKey());
    }

    @Override
    public CEKey getKey() {
        return (CEKey)super.getKey();
    }

    @Override
    public CPart expectLoneCPart() {
        return this.cpart;
    }

    @Override
    protected void resolveAndConfigure_(Scope scope, Scope builderScope) throws EBuildException {
        this.logger.setProvisionalHeading("\n--- Resolve ---");
        this.resolveDependencies();
        this.logger.setProvisionalHeading(null);
        for (BuildPlan bp : this.subPlans.values()) {
            bp.resolveAndConfigure(scope, builderScope);
        }
        ComponentCDependencies deps = this.newCDependencies();
        this.cpart.setDependencies(deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveDependencies() throws EBuildException {
        EBuildContext.start(this.context);
        try {
            ComponentProjectHelper phelper = this.component.getProjectHelper();
            this.resolveContext(phelper);
            Map<String, ? extends Iterable<ComponentXml.Include>> moduleSelections = this.component.getModuleSelectionXml(this.conf_plan);
            for (String k : moduleSelections.keySet()) {
                HashMap<Module, Triple<ConfSet, ConfMapping, Boolean>> dparts = new HashMap<Module, Triple<ConfSet, ConfMapping, Boolean>>();
                Iterable<ComponentXml.Include> deps = moduleSelections.get(k);
                for (ComponentXml.Include d : deps) {
                    String source;
                    if (!this.conf_plan.includesAll(EBuildUtil.parseConfSet(d.confs)) || "system".equals(source = d.source) || "checkedin".equals(source)) continue;
                    EKey dkey = this.context.newModuleKey(d);
                    Module dpart = (Module)this.resolveElement(this.context, source, dkey);
                    ConfSet conf = EBuildUtil.parseConfSet(d.confs);
                    ConfMapping mapping = EBuildUtil.parseMapping(d.mapping, ConfMapping.EMPTY);
                    dparts.put(dpart, new Triple<ConfSet, ConfMapping, Boolean>(conf, mapping, d.dependencies));
                }
                ILogger subLogger = this.logger.newSubLogger("" + k);
                Pair<CEKey, String> key = new Pair<CEKey, String>(this.getKey(), k);
                BuildPlan subPlan = this.runner.buildPlans.get(key);
                if (subPlan == null) {
                    subPlan = new ModuleBuildPlan(this.runner, subLogger, key, this.conf_plan, dparts);
                }
                this.subPlans.put(k, subPlan);
            }
            Map<String, Xml.SelectAndMap> components = this.component.getSelectedComponentsXml(this.conf_plan);
            for (String k : components.keySet()) {
                Xml.SelectAndMap d = components.get(k);
                EKey dkey = this.context.newElementKey(ElementType.component, d);
                Component dpart = (Component)this.resolveElement(this.context, d.source, dkey);
                ConfMapping mapping = EBuildUtil.parseMapping(d.mapping, ConfMapping.EMPTY);
                ConfSet dconf = mapping.select(this.conf_plan);
                ILogger subLogger = this.logger.newSubLogger("" + k);
                CEKey cekey = new CEKey(dpart.key, dconf);
                BuildPlan subPlan = this.runner.buildPlans.get(cekey);
                if (subPlan == null) {
                    subPlan = new ComponentBuildPlan(this.runner, subLogger, dpart, dconf);
                }
                this.subPlans.put(k, subPlan);
            }
        }
        finally {
            EBuildContext.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentCDependencies newCDependencies() throws EBuildException {
        EBuildContext.start(this.context);
        try {
            ComponentCDependencies r = new ComponentCDependencies();
            for (String k : this.subPlans.keySet()) {
                BuildPlan bp = this.subPlans.get(k);
                if (bp instanceof ModuleBuildPlan) {
                    ModuleBuildPlan mbp = (ModuleBuildPlan)bp;
                    Collection<CPart> mods = mbp.getPrimaryModules();
                    r.addModuleSelection(new ComponentCDependencies.ModuleSelectionDep(k, mods, mbp.excludeDependencies));
                    continue;
                }
                ComponentBuildPlan cbp = (ComponentBuildPlan)bp;
                r.addComponent(new ComponentCDependencies.ComponentDep(k, cbp.cpart));
            }
            ComponentCDependencies componentCDependencies = r;
            return componentCDependencies;
        }
        finally {
            EBuildContext.end();
        }
    }

    @Override
    protected void resolveBuilders(Scope scope) throws EBuildException {
        this.resolveBuildersForPart(this.cpart, this.conf_plan);
    }

    @Override
    protected void buildActionList_(ActionQueue queue, Task task) throws Exception {
        for (BuildPlan subPlan : this.subPlans.values()) {
            subPlan.buildActionList(queue, task);
        }
        this.buildActionListForPart(queue, task, this.cpart);
    }
}

