/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IAssemblerArgument;
import ebuild.api.IEBuild;
import ebuild.api.IInputMap;
import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.conf.ConfSet;
import ebuild.core.BuildProject;
import ebuild.core.CPart;
import ebuild.core.Component;
import ebuild.core.ComponentCDependencies;
import ebuild.core.ComponentRelease;
import ebuild.core.EBuild;
import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Input;
import ebuild.core.InputMap;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuildProject
extends BuildProject<Component> {
    private final EBuild ebuild;
    private final Component component;
    final Map<String, ComponentXml.AssemblyResult> artifacts = new HashMap<String, ComponentXml.AssemblyResult>();
    final Map<String, ArtifactGenerator> namedGenerators = new HashMap<String, ArtifactGenerator>();

    public ComponentBuildProject(CPart<Component> cpart) {
        super((CPart)cpart);
        this.component = (Component)cpart.part;
        this.ebuild = this.component.ebuild;
    }

    @Override
    public void buildRun() throws Exception {
        ArtifactGenerator releaseGenerator = this.construct();
        Collection<File> artifacts = releaseGenerator.assemble(this.ebuild);
        if (artifacts.size() != 1) {
            throw EBuildUtil.newProblem("Expected single artifact from release, got " + artifacts.size());
        }
        File a = artifacts.iterator().next();
        FileUtil.copy(a, this.cpart.release.getFile());
    }

    private ComponentXml.Assembly getAssemblyXml() throws EBuildException {
        return this.component.getProjectHelper().getAssemblyXml();
    }

    public ArtifactGenerator construct() throws EBuildException, BuildPluginException {
        for (ComponentXml.AssemblyResult a : this.getAssemblyXml().assemblyResults) {
            this.artifacts.put(a.name, a);
        }
        String startId = this.getAssemblyXml().release;
        return this.getAssembler(startId);
    }

    private ArtifactGenerator getAssembler(String ref) throws EBuildException, BuildPluginException {
        ArtifactGenerator r = this.namedGenerators.get(ref);
        if (r == null) {
            r = this.newArtifactGenerator(ref);
            this.namedGenerators.put(ref, r);
        }
        return r;
    }

    private ArtifactGenerator newArtifactGenerator(String ref) throws EBuildException, BuildPluginException {
        ComponentXml.AssemblyResult a = this.artifacts.get(ref);
        if (a != null) {
            return this.newArtifactGenerator(ref, a);
        }
        throw EBuildUtil.newProblem("Bad reference, no <artifact> or <module-selection> id for ref: " + ref);
    }

    private ArtifactGenerator newArtifactGenerator(String path, ComponentXml.Conditional cond) throws EBuildException, BuildPluginException {
        if (cond.ref != null) {
            return this.getAssembler(cond.ref);
        }
        return this.newArtifactGenerator(path, (ComponentXml.AssemblerParent)cond);
    }

    private ArtifactGenerator newArtifactGenerator(String path, ComponentXml.AssemblerParent parent) throws EBuildException, BuildPluginException {
        ArtifactGenerator r = this.newArtifactGenerator_(path, parent);
        r.setOutputDir(new File(this.getIntermediateDirectory(), path));
        return r;
    }

    private ArtifactGenerator newArtifactGenerator_(String path, ComponentXml.AssemblerParent parent) throws EBuildException, BuildPluginException {
        if (parent.component != null) {
            return this.newArtifactGenerator(path, parent.component);
        }
        ComponentXml.ModuleSelection ms = parent.moduleSelection;
        if (ms != null) {
            return this.newArtifactGenerator(path, ms);
        }
        ComponentXml.If if_ = parent.if_;
        ComponentXml.Else else_ = parent.else_;
        if (if_ != null || else_ != null) {
            if (if_ == null || else_ == null) {
                throw EBuildUtil.newProblem("Both conditions <if> && <else> must be present (covering all cases)");
            }
            ConfSet confs = EBuildUtil.parseConfSet(if_.confs);
            if (this.getConfiguration().includesAll(confs)) {
                return this.newArtifactGenerator(path, if_);
            }
            return this.newArtifactGenerator(path, else_);
        }
        ComponentXml.Assembler assemblerXml = parent.assembler;
        if (assemblerXml == null) {
            throw EBuildUtil.newProblem("No assembler specified:\n " + parent);
        }
        LinkedHashMap<String, ArtifactGenerator> inputs = new LinkedHashMap<String, ArtifactGenerator>();
        for (ComponentXml.Input i : assemblerXml.inputList) {
            String name;
            ArtifactGenerator a;
            if (i.ref != null) {
                a = this.getAssembler(i.ref);
            } else {
                String path2 = i.appendToPath(path);
                a = this.newArtifactGenerator(path2, i);
            }
            String string = name = i.name == null ? "anonymous" : i.name;
            if (inputs.containsKey(name)) {
                throw EBuildUtil.newProblem("Multiple inputs must have distinct names: " + name);
            }
            inputs.put(i.name, a);
        }
        EKey assemblerKey = this.component.getProjectHelper().context.newModuleKey(assemblerXml);
        Module assemblerModule = this.cpart.getDependencies().builders.get(assemblerKey);
        EKey resolvedKey = assemblerModule.key;
        AbstractAssembler assembler = this.ebuild.expectAssembler(resolvedKey);
        IPropertyMap properties = EBuildUtil.configureProperties(assembler.newPropertyMap(), this.getConfiguration(), assemblerXml.propsList);
        return new AssemblerInstance(assembler, inputs, properties);
    }

    private ArtifactGenerator newArtifactGenerator(String path, ComponentXml.ModuleSelection ms) throws EBuildException {
        final HashSet<EKey> excludes = new HashSet<EKey>();
        for (Xml.Select exclude : ms.excludes) {
            EKey key = this.component.context.newModuleKey(exclude);
            excludes.add(key);
        }
        CollectionUtil.Filter<ModuleCDependencies.AbstractDep> inclusionFilter = new CollectionUtil.Filter<ModuleCDependencies.AbstractDep>(){

            @Override
            public boolean accept(ModuleCDependencies.AbstractDep dep) {
                if (dep.scope != Scope.MAIN) {
                    return false;
                }
                return !excludes.contains(dep.key);
            }
        };
        HashSet<IModuleRelease> modules = new HashSet<IModuleRelease>();
        ComponentCDependencies deps = (ComponentCDependencies)this.cpart.getDependencies();
        ComponentCDependencies.ModuleSelectionDep dep = deps.moduleSelections.get(path);
        dep.buildModuleCollection(inclusionFilter, modules);
        String[] artifactTypes = ms.artifactType.split(",");
        return new ModuleSelectionInstance(modules, artifactTypes);
    }

    private ArtifactGenerator newArtifactGenerator(String path, Xml.SelectAndMap component) throws EBuildException {
        ComponentCDependencies deps = (ComponentCDependencies)this.cpart.getDependencies();
        ComponentCDependencies.ComponentDep dep = deps.components.get(path);
        return new ComponentSelect((ComponentRelease)dep.cpart.release);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentSelect
    extends ArtifactGenerator {
        final ComponentRelease release;

        ComponentSelect(ComponentRelease release) {
            this.release = release;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws Exception {
            return CollectionUtil.singletonList(this.release.getFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleSelectionInstance
    extends ArtifactGenerator {
        final Collection<IModuleRelease> modules;
        final String[] artifactTypes;

        public ModuleSelectionInstance(Collection<IModuleRelease> modules, String[] artifactTypes) {
            this.modules = modules;
            this.artifactTypes = artifactTypes;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws Exception {
            ArrayList<File> r = new ArrayList<File>(this.modules.size());
            for (IModuleRelease m : this.modules) {
                for (String type : this.artifactTypes) {
                    r.addAll(m.getArtifacts(Scope.MAIN, type));
                }
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblerInstance
    extends ArtifactGenerator {
        final AbstractAssembler assembler;
        final Map<String, ArtifactGenerator> inputGenerators;
        final IPropertyMap properties;

        public AssemblerInstance(AbstractAssembler assembler, Map<String, ArtifactGenerator> inputGenerators, IPropertyMap properties) throws EBuildException {
            this.assembler = assembler;
            this.inputGenerators = inputGenerators;
            this.properties = properties;
        }

        @Override
        public Collection<File> assemble_(final EBuild ebuild) throws Exception {
            final InputMap inputs = new InputMap();
            for (String key : this.inputGenerators.keySet()) {
                ArtifactGenerator apc = this.inputGenerators.get(key);
                Collection<File> a = apc.assemble(ebuild);
                inputs.put(key, new Input(key, a));
            }
            return this.assembler.assemble(new IAssemblerArgument(){

                public IEBuild getEBuild() {
                    return ebuild;
                }

                public ILogger getLogger() {
                    return ebuild.logger.newSubLogger(AssemblerInstance.this.assembler.getClass().getSimpleName());
                }

                public IPropertyMap getPropertyMap() {
                    return AssemblerInstance.this.properties;
                }

                public IInputMap getInputMap() {
                    return inputs;
                }

                public File getOutputDirectory() {
                    return AssemblerInstance.this.useOutputDir();
                }

                public Date getLastCommitDate() {
                    return ComponentBuildProject.this.component.getLastCommitDate();
                }

                public String getVersionString() {
                    return "" + ((ComponentBuildProject)ComponentBuildProject.this).component.key.version;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ArtifactGenerator {
        private File outputDir;
        private Collection<File> artifacts = null;

        ArtifactGenerator() {
        }

        final Collection<File> assemble(EBuild ebuild) throws Exception {
            if (this.artifacts == null) {
                this.artifacts = this.assemble_(ebuild);
            }
            return this.artifacts;
        }

        abstract Collection<File> assemble_(EBuild var1) throws Exception;

        public void setOutputDir(File outputDir) {
            this.outputDir = outputDir;
        }

        public File useOutputDir() {
            this.outputDir.mkdirs();
            return this.outputDir;
        }
    }
}

