/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.conf.ConfSet;
import ebuild.core.BuildProject;
import ebuild.core.CPart;
import ebuild.core.Component;
import ebuild.core.ComponentBuildProject;
import ebuild.core.ComponentRelease;
import ebuild.core.EclipseProject;
import ebuild.core.Part;
import ebuild.core.Release;
import ebuild.util.NameTemplate;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentCPart
extends CPart<Component> {
    public ComponentCPart(Component component, ConfSet conf, ConfSet confSelected) {
        super(component, conf, confSelected);
    }

    @Override
    public BuildProject newBuildProject() {
        return new ComponentBuildProject((CPart<Component>)this);
    }

    @Override
    public EclipseProject newEclipseProject() {
        return new EclipseProject<Part>((CPart)this){};
    }

    @Override
    public Release newRelease() {
        return new ComponentRelease(this.releaseFile());
    }

    public String releaseFileName() {
        String r = ((Component)this.part).getNameTemplateOfOutput().apply(new NameTemplate.Model(){

            public String getValue(String varname) {
                if ("confs".equals(varname)) {
                    return ComponentCPart.this.getConfigurationSelected().asFileTrailingPart(((Component)ComponentCPart.this.part).getConfsNotUsedInName());
                }
                if ("version".equals(varname)) {
                    return ((Component)ComponentCPart.this.part).key.version + "";
                }
                return null;
            }
        });
        r = r + this.getAdditionalSuffixes();
        return r;
    }

    public File releaseFile() {
        return new File(((Component)this.part).getReleaseDirectory(), this.releaseFileName());
    }

    public String getAdditionalSuffixes() {
        String r = "";
        for (Xml.Configuration c : ((ComponentXml.EbuildComponent)((Component)this.part).getDeclaration()).configurations) {
            if (!this.getConfiguration().includes(c.name) || c.suffix == null) continue;
            r = r + "." + c.suffix;
        }
        return r;
    }
}

