/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.conf.ConfSet;
import ebuild.core.Component;
import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.core.ProjectHelper;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentProjectHelper
extends ProjectHelper {
    final Component component;
    private ComponentXml.EbuildComponentAssembly buildXml;

    ComponentProjectHelper(Component component) {
        super(component);
        this.component = component;
    }

    @Override
    public ComponentXml.EbuildComponentAssembly getBuildXml() throws EBuildException {
        if (this.buildXml == null) {
            File f = new File(this.component.getMetaDirectory(), "component-assembly.xml");
            this.buildXml = (ComponentXml.EbuildComponentAssembly)EBuildUtil.parseXml(this.component.ebuild, this.component.key, f);
        }
        return this.buildXml;
    }

    public ComponentXml.Assembly getAssemblyXml() throws EBuildException {
        return this.getBuildXml().assembly;
    }

    @Override
    public Iterable<? extends Xml.Select> getBuildDependencies(ConfSet configuration) throws EBuildException {
        final HashSet r = new HashSet(10);
        new AssemblyVisitor(configuration){

            public void visitAssembler(String path, ComponentXml.Assembler assembler) {
                r.add(assembler);
            }
        }.go();
        return r;
    }

    ComponentXml.AssemblyResult getAssemblyResult(String name) {
        for (ComponentXml.AssemblyResult a : this.buildXml.assembly.assemblyResults) {
            if (!name.equals(a.name)) continue;
            return a;
        }
        return null;
    }

    abstract class AssemblyVisitor {
        final ConfSet configuration;
        Set<String> norecurse = new HashSet<String>();

        AssemblyVisitor() {
            this(null);
        }

        AssemblyVisitor(ConfSet configuration) {
            this.configuration = configuration;
        }

        void go() throws EBuildException {
            String startRef = ComponentProjectHelper.this.getBuildXml().assembly.release;
            this.recurse(startRef, ComponentProjectHelper.this.getAssemblyResult(startRef));
        }

        void visitComponent(String path, Xml.SelectAndMap component) {
        }

        void visitModuleSelection(String path, ComponentXml.ModuleSelection moduleSelection) {
        }

        void visitAssembler(String path, ComponentXml.Assembler assembler) {
        }

        void recurseNamed(String path, ComponentXml.AssemblerParent parent) throws EBuildException {
            if (this.norecurse.contains(path)) {
                return;
            }
            this.norecurse.add(path);
            this.recurse(path, parent);
        }

        void recurse(String path, ComponentXml.AssemblerParent parent) throws EBuildException {
            if (parent == null) {
                return;
            }
            if (parent.component != null) {
                this.visitComponent(path, parent.component);
            } else if (parent.moduleSelection != null) {
                this.visitModuleSelection(path, parent.moduleSelection);
            } else if (parent.assembler != null) {
                this.visitAssembler(path, parent.assembler);
                for (ComponentXml.Input i : parent.assembler.inputList) {
                    if (i.ref != null) {
                        this.recurse(i.ref, ComponentProjectHelper.this.getAssemblyResult(i.ref));
                        continue;
                    }
                    String path2 = i.appendToPath(path);
                    this.recurse(path2, i);
                }
            } else if (parent.if_ != null) {
                if (this.configuration != null) {
                    ConfSet confs = EBuildUtil.parseConfSet(parent.if_.confs);
                    if (this.configuration.includesAll(confs)) {
                        this.recurseConditional(path, parent.if_);
                    } else {
                        this.recurseConditional(path, parent.else_);
                    }
                } else {
                    this.recurseConditional(path + "_if", parent.if_);
                    this.recurseConditional(path + "_else", parent.else_);
                }
            } else {
                throw EBuildUtil.newProblem("Sub element of " + parent.getDefaultElementName() + " does not contain <component/>,<module-selection/>,<assembler/>,<if/>");
            }
        }

        void recurseConditional(String path, ComponentXml.Conditional parent) throws EBuildException {
            if (parent.ref != null) {
                this.recurseNamed(parent.ref, ComponentProjectHelper.this.getAssemblyResult(parent.ref));
                return;
            }
            this.recurse(path, parent);
        }
    }
}

