/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.common.ElementType;
import ebuild.api.log.ISwitch;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.core.BuilderPrototype;
import ebuild.core.Component;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.GeneralOptions;
import ebuild.core.InstallRepoProvider;
import ebuild.core.Module;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.xml.Xml;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuild
extends EBuildDirectory
implements IEBuild {
    public static final Logger ROOT_LOGGER = Logger.newRootLogger();
    public final Logger logger;
    public final Logger logger_verbose;
    public final GeneralOptions options;
    private final boolean inferWorkingCopies;
    public final File workspaceDir;
    private final String workspacePath;
    private final File libraryDir;
    private final String libraryPath;
    private final Map<EKey, Element> libraryParts = new HashMap<EKey, Element>();
    private final Map<EKey, Element> workspaceParts = new HashMap<EKey, Element>();
    private final Map<EKey, EKey> workspaceMapping = new HashMap<EKey, EKey>();
    private final Map<EKey, AbstractAssembler> assemblers = new HashMap<EKey, AbstractAssembler>();
    private final Map<EKey, BuilderPrototype> builders = new HashMap<EKey, BuilderPrototype>();
    private final Map<String, AbstractRepositoryProvider> providers = new HashMap<String, AbstractRepositoryProvider>();

    public EBuild(GeneralOptions options) {
        this(options, Logger.newRootLogger(), true);
    }

    public EBuild(GeneralOptions options, Logger logger, boolean inferWorkingCopies) {
        super(null, EBuildMode.workspace, options.home);
        this.options = options;
        this.logger = logger;
        this.logger_verbose = logger.newSubLogger(new ISwitch(){

            public boolean isOn() {
                return EBuild.this.options.verbose;
            }
        });
        this.inferWorkingCopies = inferWorkingCopies;
        this.workspaceDir = FileUtil.canonicalFile(this.getFile(".."));
        this.workspacePath = this.workspaceDir + "";
        this.libraryDir = FileUtil.canonicalFile(this.getFile("library"));
        this.libraryPath = this.libraryDir + "";
        this.providers.put("http", new HttpRepositoryProvider());
        this.context.addRepository(this.newLazyRepositoryRef("public", "http", "http://94.76.202.199:8123/download/"));
        this.context.addRepository(this.newLazyRepositoryRef("maven-public", "maven", "named://maven-public"));
        this.context.addRepository(this.newLazyRepositoryRef("ivy-roundup", "ivy", "named://ivy-roundup"));
        this.context.addRepository(this.newAliasRepositoryRef("ibiblio", "maven-public"));
        this.context.addRepository(this.newAliasRepositoryRef("ivyroundup", "ivy-roundup"));
    }

    private RepositoryRef newLazyRepositoryRef(String name, final String type, final String uri) {
        return new RepositoryRef(this.context, name, null){

            public IRepository getRepository() {
                try {
                    return EBuild.this.getRepository(type, uri);
                }
                catch (EBuildException e) {
                    throw new Error(e);
                }
            }
        };
    }

    private RepositoryRef newAliasRepositoryRef(String name, final String aliased) {
        return new RepositoryRef(this.context, name, null){

            public IRepository getRepository() {
                return this.context.getRepository(aliased).getRepository();
            }
        };
    }

    public Collection<Element> getResolvedLibraryElements() {
        return this.libraryParts.values();
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    @Override
    public String formatAsDisplayPath(File f) {
        String fpath = (f = FileUtil.canonicalFile(f)) + "";
        if (fpath.startsWith(this.libraryPath)) {
            return "[library]" + fpath.substring(this.libraryPath.length());
        }
        if (fpath.startsWith(this.workspacePath)) {
            return "[workspace]" + fpath.substring(this.workspacePath.length());
        }
        return fpath;
    }

    @Override
    public boolean isVerbose() {
        return this.options.verbose;
    }

    public boolean isDEBUG() {
        return this.options.debug;
    }

    public File getLibraryDirectory() {
        return this.libraryDir;
    }

    public File getUniverseDirectory(String universe) {
        return new File(this.libraryDir, universe);
    }

    @Override
    public File getCredentialsFile(String path) {
        return this.getFile("credentials/" + path);
    }

    public void registerBuilder(EKey key, BuilderPrototype builder) {
        this.builders.put(key, builder);
    }

    public void registerBuilder(EKey key, AbstractAssembler assembler) {
        this.assemblers.put(key, assembler);
    }

    public void registerRepositoryProvider(String type, AbstractRepositoryProvider plugin) {
        this.providers.put(type, plugin);
    }

    public BuilderPrototype expectBuilder(EKey key) throws EBuildException {
        BuilderPrototype r = this.builders.get(key);
        if (r == null) {
            throw EBuildUtil.newProblem("Unknown builder: " + key);
        }
        return r;
    }

    public AbstractAssembler expectAssembler(EKey key) throws EBuildException {
        AbstractAssembler r = this.assemblers.get(key);
        if (r == null) {
            throw EBuildUtil.newProblem("Unknown assembler: " + key);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element newPart(EBuildMode mode, ElementNature nature, File projectDir, EKey key) throws EBuildException {
        EBuildContext.start(this.context);
        try {
            Element element = this.newElement(mode, projectDir, key, nature);
            return element;
        }
        finally {
            EBuildContext.end();
        }
    }

    private Element newElement(EBuildMode mode, File projectDir, EKey key, ElementNature nature) throws EBuildException {
        Element r = this.newElement_(mode, projectDir, key, nature);
        Xml.EBuildRoot declaration = (Xml.EBuildRoot)EBuildUtil.parseXml(this, key, new File(r.getMetaDirectory(), EBuildUtil.elementType2xmlName(key.type)));
        r.initDeclaration(declaration);
        return r;
    }

    private Element newElement_(EBuildMode mode, File projectDir, EKey key, ElementNature nature) throws EBuildException {
        switch (key.type) {
            case component: {
                return new Component(mode, projectDir, this, key, nature);
            }
            case module: {
                return new Module(mode, projectDir, this, key, nature);
            }
        }
        throw new Error("!");
    }

    public EKey remapKey(EKey key) {
        EKey wkey = this.workspaceMapping.get(key);
        if (wkey != null) {
            return wkey;
        }
        return key;
    }

    public Element newWorkspaceElement(EKey key) throws EBuildException {
        String projectName = key.getDefaultWorkspaceName();
        File projectDir = new File(this.workspaceDir, projectName);
        if (projectDir.exists()) {
            EKey wkey = EKey.newWorkingKey(key.type, projectDir);
            this.workspaceMapping.put(key, wkey);
            return this.newPart(EBuildMode.workspace, ElementNature.source, projectDir, wkey);
        }
        return null;
    }

    public boolean hasWorkspaceElement(EKey key) {
        String projectName = key.getDefaultWorkspaceName();
        File projectDir = new File(this.workspaceDir, projectName);
        return projectDir.exists();
    }

    public Element resolveWorkspaceElement(EKey key) throws EBuildException {
        Element r = this.workspaceParts.get(key);
        if (r == null && (r = this.newWorkspaceElement(key)) != null) {
            this.workspaceParts.put(key, r);
            AbstractWorkingCopy wc = this.inferWorkingCopy(r.javaFile());
            if (wc != null) {
                r.setRepository(wc.getRepository());
                r.setWorkingCopy(wc);
            } else {
                r.setRepository(null);
            }
        }
        return r;
    }

    public Element resolveLibraryPart(RepositoryContext repoContext, EKey key) throws EBuildException {
        assert (!"workspace".equals(key.version.getRevision()));
        Element r = this.libraryParts.get(key);
        if (r == null) {
            String universe = repoContext.getUniverse();
            File universeDir = new File(this.getLibraryDirectory(), universe);
            File dir4version = key.getSubDirectory(universeDir);
            repoContext.fetchMeta(key, dir4version);
            ElementNature nature = repoContext.determineNature(key, dir4version);
            if (key.type == null) {
                ElementType type = EBuildUtil.determineElementType(dir4version);
                key = key.withType(type);
            }
            r = this.newPart(EBuildMode.library, nature, dir4version, key);
            r.setRepository(repoContext.repo);
            this.libraryParts.put(key, r);
        }
        return r;
    }

    public AbstractRepositoryProvider expectProviderPlugin(String repoType) throws EBuildException {
        AbstractRepositoryProvider r = this.providers.get(repoType);
        if (r == null) {
            r = InstallRepoProvider.install(this, repoType);
            this.providers.put(repoType, r);
        }
        return r;
    }

    public String inferRepositoryType(File dir) {
        if (new File(dir, ".svn").isDirectory()) {
            return "svn";
        }
        return null;
    }

    public AbstractWorkingCopy inferWorkingCopy(File dir) throws EBuildException {
        try {
            if (!this.inferWorkingCopies) {
                return null;
            }
            String type = this.inferRepositoryType(dir);
            if (type == null) {
                return null;
            }
            AbstractRepositoryProvider prov = this.expectProviderPlugin("svn");
            return prov.getWorkingCopy(dir);
        }
        catch (RepositoryPluginException e) {
            throw EBuildUtil.wrapPluginException("Could not infer source control for dir '" + this.formatAsDisplayPath(dir) + "'", e);
        }
    }

    public IRepository getRepository(String repositoryType, String repositoryUrl) throws EBuildException {
        AbstractRepositoryProvider prov = this.expectProviderPlugin(repositoryType);
        try {
            return prov.getRepository(repositoryUrl);
        }
        catch (RepositoryPluginException e) {
            throw EBuildUtil.wrapPluginException("Could not creat repository '" + repositoryUrl + "'", e);
        }
    }

    public IRepository getRepository(Xml.Repository repoXml) throws EBuildException {
        return this.getRepository(repoXml.type, repoXml.url);
    }
}

