/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.core.EBuild;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Element;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.Version;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.util.ObjectUtil;
import ebuild.util.PObject;
import ebuild.util.tuple.Pair;
import ebuild.xml.Xml;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildContext {
    private static Stack<EBuildContext> stack = new Stack();
    private static final int REPOSITORIES = 0;
    private static final int SIZE = 1;
    private final PObject[] pobjs = new PObject[1];
    final EBuildDirectory directory;
    final Element element;
    final Type type;
    private List<EBuildContext> parents;
    private Map<Pair<String, EKey>, Element> resolvedElements;
    private Map<String, String> upstreamRevisions;

    public static void start(EBuildContext context) {
        stack.push(context);
    }

    public static void end() {
        stack.pop();
    }

    public static EBuildContext get() {
        if (stack.size() == 0) {
            return null;
        }
        return stack.peek();
    }

    public static EBuildContext expect() {
        if (stack.size() == 0) {
            throw new Error();
        }
        return stack.peek();
    }

    public EBuildContext(EBuildDirectory directory, Element element, Type type) {
        for (int i = 0; i < 1; ++i) {
            this.pobjs[i] = new PObject();
        }
        this.parents = new LinkedList<EBuildContext>();
        this.resolvedElements = new HashMap<Pair<String, EKey>, Element>();
        this.directory = directory;
        this.element = element;
        this.type = type;
    }

    private EBuild ebuild() {
        return this.directory.ebuild;
    }

    public boolean isInited() {
        return this.parents.size() > 0;
    }

    public void init(Collection<EBuildContext> parentContexts) {
        this.parents.addAll(parentContexts);
        for (int i = 0; i < 1; ++i) {
            PObject[] prototypes = new PObject[parentContexts.size()];
            int j = 0;
            for (EBuildContext parentContext : parentContexts) {
                prototypes[j] = parentContext.pobjs[i];
                ++j;
            }
            this.pobjs[i].addPrototypes(prototypes);
        }
    }

    public RepositoryRef getRepository(String key) {
        return (RepositoryRef)this.pobjs[0].get(key);
    }

    public void addRepository(RepositoryRef value) {
        this.pobjs[0].put(value.name, value);
    }

    public void addRepository(String name, IRepository repository, String defaultOrg) {
        RepositoryRef repoRef = repository instanceof AbstractSourceRepository ? new RepositoryRef.Source(this, name, (AbstractSourceRepository)repository, defaultOrg) : new RepositoryRef(this, name, repository, defaultOrg);
        this.addRepository(repoRef);
    }

    public RepositoryRef lookupRepository(String source) throws EBuildException {
        if ("system".equals(source)) {
            return null;
        }
        RepositoryRef repo = this.getRepository(source);
        if (repo == null) {
            if (!this.isInited()) {
                throw new Error("!" + this + " " + source);
            }
            throw EBuildUtil.newProblem("Bad source, no repository defined in scope '" + this + "'for '" + source + "'");
        }
        return repo;
    }

    public EKey newModuleKey(Xml.Select select) throws EBuildException {
        return this.newElementKey(ElementType.module, select);
    }

    public EKey newElementKey(ElementType type, Xml.Select select) throws EBuildException {
        String universe;
        String source = select.source;
        String name = select.name;
        String org = select.org;
        if ("local".equals(select.source)) {
            if (org == null) {
                org = this.element.key.org;
            }
            universe = this.element.key.universe;
        } else {
            RepositoryRef repoRef = this.lookupRepository(select.source);
            if (repoRef == null) {
                universe = source;
            } else {
                universe = repoRef.getUniverse();
                if (org == null) {
                    org = repoRef.getDefaultOrg();
                }
            }
        }
        if (select.version != null) {
            return EKey.newVersioned(type, universe, org, name, select.version);
        }
        return EKey.newRevision(type, universe, org, name, select.branch, select.revision);
    }

    public Element resolveElement(String source, EKey dkey) throws EBuildException {
        Pair<String, EKey> key = new Pair<String, EKey>(source, dkey);
        Element r = this.resolvedElements.get(key);
        if (r == null) {
            r = this.resolveElement_(source, dkey);
            this.resolvedElements.put(key, r);
        }
        return r;
    }

    private Element resolveLibraryPart(IRepository repo, EKey key) throws EBuildException {
        return this.ebuild().resolveLibraryPart(new RepositoryContext(repo), key);
    }

    private Element resolveElement_(String source, EKey dkey) throws EBuildException {
        RepositoryRef repoRef = this.lookupRepository(source);
        if (dkey.version.isMoving()) {
            return this.resolveMoving(repoRef, dkey);
        }
        return this.resolveLibraryPart(repoRef.getRepository(), dkey);
    }

    public Element resolveMoving(RepositoryRef repoRef, EKey dkey) throws EBuildException {
        String revision;
        boolean local = "local".equals(repoRef.name);
        if (this.element.isWorkspace()) {
            String revision2;
            RepositoryRef.Source srepoRef;
            Element we = this.ebuild().resolveWorkspaceElement(dkey);
            if (we != null) {
                if (!local) {
                    RepositoryRef.Source srepoRef2 = (RepositoryRef.Source)repoRef;
                    srepoRef2.setFixedRevisionToWorkspace(this, dkey);
                }
                return we;
            }
            if (!local) {
                srepoRef = (RepositoryRef.Source)repoRef;
                revision2 = srepoRef.getUpdatedFixedRevision(this, dkey);
            } else {
                if (repoRef.getRepository() == null) {
                    throw EBuildUtil.newProblem("'" + this.element.key + "' not connected to a repository, and cannot resolve local depondency '" + dkey + "' in the workspace");
                }
                srepoRef = (RepositoryRef.Source)repoRef;
                revision2 = EBuildUtil.getHeadRevision(srepoRef.getRepository());
            }
            Version v2 = dkey.version.withRevision(revision2);
            EKey dkey2 = dkey.withVersion(v2);
            return this.resolveLibraryPart(repoRef.getRepository(), dkey2);
        }
        if (!local) {
            RepositoryRef.Source srepoRef = (RepositoryRef.Source)repoRef;
            revision = srepoRef.expectFixedRevision();
        } else {
            revision = this.element.key.version.getRevision();
        }
        Version v2 = dkey.version.withRevision(revision);
        EKey dkey2 = dkey.withVersion(v2);
        return this.resolveLibraryPart(repoRef.getRepository(), dkey2);
    }

    private File getUpstreamRevisionsFile() {
        File metaDir = this.element.getMetaDirectory();
        File old = new File(metaDir, "upstream.revisions");
        if (old.exists()) {
            return old;
        }
        String filename = FileUtil.removeSuffix(this.filename()) + ".revisions";
        return new File(metaDir, filename);
    }

    private Map<String, String> readUpstreamRevisions() {
        File f = this.getUpstreamRevisionsFile();
        if (!f.exists()) {
            return new HashMap<String, String>();
        }
        try {
            return JSONUtil.readMap(new FileReader(f));
        }
        catch (Exception e) {
            this.ebuild().log("Unable to read: " + f + ", " + e.getMessage());
            if (this.ebuild().isDEBUG()) {
                this.ebuild().logger.log(e);
            }
            return new HashMap<String, String>();
        }
    }

    public Map<String, String> getUpstreamRevisions() {
        if (this.upstreamRevisions == null) {
            this.upstreamRevisions = this.readUpstreamRevisions();
        }
        return this.upstreamRevisions;
    }

    public void updateUpstreamRevisions(Map<String, String> upstreamRevisions) {
        this.upstreamRevisions = upstreamRevisions;
        File f = this.getUpstreamRevisionsFile();
        try {
            JSONUtil.writeObject(new FileWriter(f), upstreamRevisions);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write: " + f, e);
        }
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.directory) + ObjectUtil.hashOf((Object)this.type);
    }

    public boolean equals(Object obj) {
        EBuildContext b = (EBuildContext)obj;
        return ObjectUtil.areEqual(this.directory, b.directory) && ObjectUtil.areEqual((Object)this.type, (Object)b.type);
    }

    public String filename() {
        switch (this.type) {
            case main: {
                return EBuildUtil.elementType2xmlName(this.element.getType());
            }
            case build: {
                return EBuildUtil.elementType2buildXmlName(this.element.getType());
            }
            case builtin: {
                return "<builtin>";
            }
        }
        throw new Error("!");
    }

    public String toString() {
        return this.directory + "," + this.filename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        builtin,
        main,
        build;

    }
}

