/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildUtil;
import ebuild.core.Element;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class EBuildDirectory {
    private final File f;
    public final EBuild ebuild;
    public final EBuildMode mode;
    public final EBuildContext context;
    private IRepository repository = null;
    private AbstractWorkingCopy workingCopy = null;

    public EBuildDirectory(EBuild ebuild, EBuildMode mode, File directory) {
        this.f = EBuildUtil.canonicalFile(directory);
        this.mode = mode;
        if (ebuild == null) {
            this.ebuild = (EBuild)this;
            this.context = new EBuildContext(this, null, EBuildContext.Type.builtin);
        } else {
            this.ebuild = ebuild;
            this.context = new EBuildContext(this, (Element)this, EBuildContext.Type.main);
        }
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public AbstractWorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(AbstractWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    public boolean isWorkspace() {
        return this.mode == EBuildMode.workspace;
    }

    public void mkdirs() throws IOException {
        if (!this.f.isDirectory() && !this.f.mkdirs()) {
            throw new IOException("Unable to make dirs: " + this.f);
        }
    }

    public File javaFile() {
        return this.f;
    }

    public String getName() {
        return this.f.getName();
    }

    public File getFile(String name) {
        return new File(this.f, name);
    }

    public boolean hasFile(String path) {
        return this.getFile(path).exists();
    }

    public Reader readFile(String name) throws IOException {
        File f = this.getFile(name);
        if (!f.isFile()) {
            throw new IOException(f + " does not exist");
        }
        return new FileReader(f);
    }
}

