/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.conf.ConfSet;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.core.GeneralOptions;
import ebuild.core.Part;
import ebuild.core.Task;
import ebuild.util.StringUtil;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class EBuildRunner {
    protected final EBuild ebuild;
    protected final ILogger logger;
    public CPart principalRelease = null;
    public final ActionQueue queue = new ActionQueue();
    public final Set<CPart> releases = new HashSet<CPart>();
    final Map<Object, BuildPlan> buildPlans = new LinkedHashMap<Object, BuildPlan>();

    public EBuildRunner(EBuild ebuild) {
        this.ebuild = ebuild;
        this.logger = ebuild.logger;
    }

    public EBuildRunner(GeneralOptions options) {
        this(new EBuild(options));
    }

    public abstract void go() throws Exception;

    protected void log(String msg, boolean cond) {
        if (cond) {
            this.log(msg);
        }
    }

    protected void log(String msg) {
        this.logger.log(msg);
    }

    protected void log(Throwable t) {
        this.logger.log(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.ebuild.isDEBUG()) {
            ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
            this.logger.log("ebuild runtime path: ");
            for (int i = 0; i < urls.length; ++i) {
                this.logger.log("    " + urls[i].getFile());
            }
        }
        try {
            this.go();
        }
        catch (EBuildException e) {
            this.log("");
            this.log("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            if (this.ebuild.isDEBUG()) {
                this.log(e);
            } else {
                this.log("!!! PROBLEM: " + e.getMessage());
                Throwable t = EBuildUtil.getUnknownCause(e);
                if (t != null) {
                    this.log(t);
                }
            }
        }
        finally {
            this.logger.prime();
        }
    }

    public void go(Part part, String confStr, Task task) throws Exception {
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        BuildPlan mainPlan = this.resolveAndConfigure(part, confStr, task.getScope(), task.getBuilderScope());
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, task);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.queue);
    }

    protected BuildPlan resolveAndConfigure(Part part, String confStr, Scope scope, Scope builderScope) throws Exception {
        ConfSet confs = EBuildUtil.parseConfSet(confStr);
        BuildPlan mainPlan = part.newBuildPlan(this, confs, this.logger);
        mainPlan.resolveAndConfigure(scope, builderScope);
        if (this.ebuild.isDEBUG()) {
            this.log("Build Plans");
            for (Object k : this.buildPlans.keySet()) {
                this.log("" + k);
            }
        }
        this.principalRelease = mainPlan.expectLoneCPart();
        return mainPlan;
    }

    private void buildActionList(BuildPlan mainPlan, Task task) throws Exception {
        mainPlan.buildActionList(this.queue, task);
        this.queue.removeDuplicates();
        for (Action a : this.queue) {
            this.log("queued " + StringUtil.rpad(6, "" + a.status.displayString()) + " " + a.format());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            EBuildContext.start(action.part.context);
            try {
                if (action.status == ActionStatus.done && !this.ebuild.options.noSkipping) {
                    this.log("- skipping " + action + " -");
                    this.logger.setProvisionalHeading("\n");
                    action.finish(true);
                    this.logger.setProvisionalHeading(null);
                    continue;
                }
                this.log("- executing " + action + " -");
                this.logger.setProvisionalHeading("\n");
                action.run(this.logger);
                this.logger.setProvisionalHeading(null);
            }
            finally {
                EBuildContext.end();
            }
        }
    }
}

