/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.conf.ConfMapping;
import ebuild.conf.ConfParser;
import ebuild.conf.ConfSet;
import ebuild.conf.MappingException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EKey;
import ebuild.core.Element;
import ebuild.util.FileUtil;
import ebuild.xml.Xml;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildUtil {
    public static final String FILENAME_CMP_DECL = "component.xml";
    public static final String FILENAME_CMP_BUILD = "component-assembly.xml";
    public static final String FILENAME_MOD_DECL = "module.xml";
    public static final String FILENAME_MOD_BUILD = "module-build.xml";

    public static String getHeadRevision(AbstractSourceRepository repo) throws EBuildException {
        try {
            return repo.getHeadRevision();
        }
        catch (RepositoryPluginException e) {
            throw EBuildUtil.wrapPluginException("Could not fetch head revision of '" + repo.getUri() + "'", e);
        }
    }

    public static EBuildException wrapPluginException(String msg, RepositoryPluginException e) {
        return EBuildUtil.newProblem(msg + "\n" + e.getMessage(), e);
    }

    public static EBuildException newProblem(String msg) {
        return EBuildUtil.newProblem(msg, null);
    }

    public static EBuildException newProblem(String msg, Throwable cause) {
        EBuildContext context = EBuildContext.get();
        Element element = context.element;
        String contextStr = element == null ? "" : element.toString() + "\n";
        return new EBuildException(contextStr + msg, cause);
    }

    public static Scope getScope(String name, Scope default_) {
        Scope r = Scope.get(name);
        if (r == null) {
            return default_;
        }
        return r;
    }

    public static IPropertyMap configureProperties(IPropertyMap r, ConfSet configuration, List<Xml.Property> propList) throws BuildPluginException, EBuildException {
        for (Xml.Property p : propList) {
            ConfSet confs = EBuildUtil.parseConfSet(p.confs);
            if (!configuration.includesAll(confs)) continue;
            r.put(p.key, p.getValue());
        }
        return r;
    }

    static ConfMapping parseMapping(String mapping, ConfMapping default_) throws EBuildException {
        if (mapping == null) {
            return default_;
        }
        try {
            return ConfParser.parseMapping(mapping);
        }
        catch (MappingException e) {
            throw EBuildUtil.newProblem("Invalid mapping '" + mapping + "' - " + e.getMessage());
        }
    }

    static ConfSet parseConfSet(String confSet) throws EBuildException {
        try {
            return ConfParser.parseConfSet(confSet);
        }
        catch (MappingException e) {
            throw EBuildUtil.newProblem("Invalid mapping '" + confSet + "' - " + e.getMessage());
        }
    }

    public static String formatElement(EBuildMode mode, ElementType type, String projectName) {
        return mode.code + " " + (Object)((Object)type) + " " + projectName;
    }

    public static File canonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }

    public static Xml parseXml(EBuild ebuild, EKey key, File f) throws EBuildException {
        try {
            return Xml.deserialize(f);
        }
        catch (Exception e) {
            throw EBuildUtil.newProblem(ebuild.formatAsDisplayPath(f) + " : " + e.getMessage());
        }
    }

    public static FileFilter getFileFilter(IRepository repo) {
        if (!(repo instanceof AbstractSourceRepository)) {
            return FileUtil.FILEFILTER_ALL;
        }
        AbstractSourceRepository srepo = (AbstractSourceRepository)repo;
        FileFilter r = srepo.getFileFilter();
        if (r == null) {
            r = FileUtil.FILEFILTER_ALL;
        }
        return r;
    }

    public static Throwable getUnknownCause(Throwable t) {
        while (t != null) {
            if (!(t instanceof EBuildException || t instanceof RepositoryPluginException || t instanceof BuildPluginException)) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static String elementType2xmlName(ElementType elementType) {
        switch (elementType) {
            case component: {
                return FILENAME_CMP_DECL;
            }
            case module: {
                return FILENAME_MOD_DECL;
            }
        }
        throw new Error("!");
    }

    public static String elementType2buildXmlName(ElementType elementType) {
        switch (elementType) {
            case component: {
                return FILENAME_CMP_BUILD;
            }
            case module: {
                return FILENAME_MOD_BUILD;
            }
        }
        throw new Error("!");
    }

    public static ElementType determineElementType(File directory) throws EBuildException {
        File metaDir = new File(directory, "meta");
        if (new File(metaDir, FILENAME_CMP_DECL).isFile()) {
            return ElementType.component;
        }
        if (new File(metaDir, FILENAME_MOD_DECL).isFile()) {
            return ElementType.module;
        }
        throw EBuildUtil.newProblem("Not an ebuild directory: " + EBuildUtil.canonicalFile(directory));
    }
}

