/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.conf.ConfSet;
import ebuild.core.BuildMode;
import ebuild.core.CPart;
import ebuild.core.EBuildDirectory;
import ebuild.core.Part;
import ebuild.core.Project;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseProject<P extends Part>
extends Project<P> {
    private boolean configurationChange = false;
    private static final String CONF_FILENAME = ".configuration";

    public EclipseProject(CPart cpart) {
        super(cpart);
    }

    public void setup() throws Exception {
        ((Part)this.cpart.getPart()).addIgnores(CollectionUtil.newList(CONF_FILENAME, ".project", ".settings", "gen", ".classpath"));
    }

    public void unsetup() throws Exception {
        ((EBuildDirectory)this.getPart()).getFile(".project").delete();
    }

    public boolean isProjectDirty() {
        return this.configurationChange;
    }

    @Override
    public BuildMode mode() {
        return BuildMode.eclipse;
    }

    public void storeConfiguration() throws IOException {
        ConfSet old;
        File f = ((EBuildDirectory)this.getPart()).getFile(CONF_FILENAME);
        if (f.exists()) {
            old = ConfSet.fromJson(IOUtil.fileToString(f));
            FileUtil.deleteOrFail(f);
        } else {
            old = ConfSet.EMPTY;
        }
        if (!this.getConfigurationSelected().isEmpty()) {
            IOUtil.stringToFile(this.getConfigurationSelected().asJson(), f);
        }
        this.configurationChange = !old.equals(this.getConfigurationSelected());
    }
}

