/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.IRepository;
import ebuild.core.EBuild;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Version;
import ebuild.xml.Xml;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element<D extends Xml.EBuildRoot>
extends EBuildDirectory {
    public final EKey key;
    private final File metaDir;
    private D declaration;

    public Element(EBuildMode mode, File directory, EBuild ebuild, EKey key) {
        super(ebuild, mode, directory);
        this.key = key;
        this.metaDir = EBuildUtil.canonicalFile(this.getFile("meta"));
    }

    @Override
    public void setRepository(IRepository repository) {
        super.setRepository(repository);
        this.context.addRepository("local", repository, this.key.org);
    }

    public void initDeclaration(D declaration) throws EBuildException {
        this.declaration = declaration;
    }

    public boolean hasMetaDirectory() {
        return this.metaDir.exists();
    }

    public File getMetaDirectory() {
        return this.metaDir;
    }

    public abstract ElementType getType();

    public D getDeclaration() {
        return this.declaration;
    }

    public void log(String msg) {
        this.ebuild.log(msg);
    }

    @Override
    public String getName() {
        return this.key.fullname();
    }

    public Version getVersion() {
        return this.key.version;
    }

    public String toString() {
        return this.mode.code + " " + this.key;
    }
}

