/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IInput;
import ebuild.api.IInputMap;
import ebuild.api.plugin.BuildPluginProblem;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMap
implements IInputMap {
    private final Map<String, IInput> inputs = new HashMap<String, IInput>(1);

    @Override
    public IInput getInput(String name) {
        return this.inputs.get(name);
    }

    @Override
    public IInput expectInput(String name) throws BuildPluginProblem {
        IInput r = this.getInput(name);
        if (r == null) {
            throw new BuildPluginProblem("Expected named input '" + name + "'");
        }
        return r;
    }

    @Override
    public IInput expectLoneInput() throws BuildPluginProblem {
        if (this.inputs.size() > 1) {
            throw new BuildPluginProblem("Expected single input, got several inputs: " + StringUtil.join(",", this.inputs.keySet()));
        }
        return this.inputs.values().iterator().next();
    }

    @Override
    public Collection<String> inputKeys() {
        return this.inputs.keySet();
    }

    @Override
    public Collection<File> getArtifacts(String input) {
        IInput r = this.getInput(input);
        if (r == null) {
            return null;
        }
        return r.getArtifacts();
    }

    @Override
    public Collection<File> getArtifacts(String input, Collection<File> default_) {
        IInput r = this.getInput(input);
        if (r == null) {
            return default_;
        }
        return r.getArtifacts();
    }

    @Override
    public Collection<File> expectArtifacts(String input) throws BuildPluginProblem {
        return this.expectInput(input).getArtifacts();
    }

    @Override
    public Collection<File> expectArtifacts() throws BuildPluginProblem {
        return this.expectLoneInput().getArtifacts();
    }

    @Override
    public File expectLoneArtifact() throws BuildPluginProblem {
        return this.expectLoneInput().expectLoneArtifact();
    }

    @Override
    public File expectLoneArtifactForInput(String input) throws BuildPluginProblem {
        return this.expectInput(input).expectLoneArtifact();
    }

    public void put(String key, IInput value) {
        this.inputs.put(key, value);
    }
}

