/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.conf.ConfSet;
import ebuild.core.BuilderPrototype;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.ElementNature;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleCPart;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.Part;
import ebuild.util.Logger;
import ebuild.xml.ModuleXml;
import ebuild.xml.Xml;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends Part<ModuleXml.EbuildModule> {
    private ModuleXml.EbuildBuildPlugin pluginXml;
    File pluginFile;
    private AbstractRepositoryProvider repositoryProvider = null;

    public Module(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
        File pluginFile = new File(this.getMetaDirectory(), "build-plugin.xml");
        if (pluginFile.exists()) {
            this.pluginFile = pluginFile;
        }
    }

    public AbstractRepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    @Override
    CPart newCPart(ConfSet conf, ConfSet confSelected) {
        return new ModuleCPart(this, conf, confSelected);
    }

    @Override
    ModuleBuildPlan newBuildPlan(EBuildRunner runner, ConfSet confSet, ILogger logger) {
        return new ModuleBuildPlan(runner, logger, this, confSet);
    }

    @Override
    public ModuleProjectHelper newProjectHelper() {
        return new ModuleProjectHelper(this);
    }

    @Override
    public ModuleProjectHelper getProjectHelper() {
        return (ModuleProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.module;
    }

    public boolean isPlugin() {
        return this.pluginFile != null;
    }

    public ModuleXml.EbuildBuildPlugin getPluginXml() throws EBuildException {
        if (this.pluginXml == null) {
            this.pluginXml = (ModuleXml.EbuildBuildPlugin)EBuildUtil.parseXml(this.ebuild, this.key, this.pluginFile);
        }
        return this.pluginXml;
    }

    public Iterable<Xml.SelectAndMap> getDependenciesXml() {
        return ((ModuleXml.EbuildModule)this.getDeclaration()).dependencies.list;
    }

    public String getJavaVersion() {
        for (Xml.SelectAndMap d : this.getDependenciesXml()) {
            if (!"system".equals(d.source) || !"jre".equals(d.name)) continue;
            return d.version;
        }
        return "1.6";
    }

    public void registerRelease(CPart cpart) throws EBuildException {
        if (this.isPlugin()) {
            ModuleXml.EbuildBuildPlugin pluginXml = this.getPluginXml();
            if (pluginXml.isBuilder()) {
                this.createBuilder(cpart);
            } else if (pluginXml.isAssembler()) {
                this.createAssembler(cpart);
            } else if (pluginXml.isRepositoryProvider()) {
                this.createRepositoryProvider(cpart);
            }
        }
    }

    private Collection<String> getClasspath_(CPart cpart, Scope scope) {
        LinkedHashSet<String> elements = new LinkedHashSet<String>();
        ((ModuleRelease)cpart.release).buildClassPath(scope, elements);
        ModuleCDependencies mcdeps = (ModuleCDependencies)cpart.getDependencies();
        mcdeps.buildClassPath(scope, elements);
        return elements;
    }

    private void logPluginPath(Collection<String> elements) {
        Logger l = this.ebuild.logger;
        l.log("plugin runtime path for '" + this.key + "': ");
        for (String s : elements) {
            l.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
    }

    public Collection<String> getClassPath(CPart cpart, Scope scope) {
        Collection<String> elements = this.getClasspath_(cpart, scope);
        if (this.ebuild.isVerbose()) {
            this.logPluginPath(elements);
        }
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object buildPluginInstance(CPart cpart, String class_) throws EBuildException {
        try {
            Collection<String> files = this.getClassPath(cpart, Scope.MAIN);
            ArrayList<URL> urls = new ArrayList<URL>(files.size());
            for (String s : files) {
                urls.add(new URL("file://" + s));
            }
            URL[] urlArray = urls.toArray(new URL[files.size()]);
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            URLClassLoader urlCl = new URLClassLoader(urlArray, prevCl){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    Class<?> loadedClass = this.findLoadedClass(name);
                    if (loadedClass == null) {
                        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("ebuild.api.")) {
                            loadedClass = super.loadClass(name);
                        } else {
                            try {
                                loadedClass = this.findClass(name);
                            }
                            catch (ClassNotFoundException e) {
                                loadedClass = super.loadClass(name);
                            }
                        }
                    }
                    return loadedClass;
                }
            };
            try {
                Thread.currentThread().setContextClassLoader(urlCl);
                Class<?> pluginClass = urlCl.loadClass(class_);
                Object obj = pluginClass.newInstance();
                return obj;
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to instantiate build plugin '" + class_ + "': class does not exist!";
                throw EBuildUtil.newProblem(msg);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
        catch (EBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    void createBuilder(CPart cpart) throws EBuildException {
        Object o = this.buildPluginInstance(cpart, this.getPluginXml().declareBuilder.class_);
        if (!(o instanceof AbstractBuilder)) {
            throw EBuildUtil.newProblem("Build Plugin class not an instanceof " + AbstractBuilder.class.getName());
        }
        ModuleXml.DeclareBuilder decl = this.pluginXml.declareBuilder;
        this.ebuild.registerBuilder(this.key, new BuilderPrototype(this.key, (AbstractBuilder)o, decl.exports));
    }

    void createAssembler(CPart cpart) throws EBuildException {
        Object o = this.buildPluginInstance(cpart, this.getPluginXml().declareAssembler.class_);
        if (!(o instanceof AbstractAssembler)) {
            throw EBuildUtil.newProblem("Build Plugin class not an instanceof " + AbstractAssembler.class.getName());
        }
        this.ebuild.registerBuilder(this.key, (AbstractAssembler)o);
    }

    void createRepositoryProvider(CPart cpart) throws EBuildException {
        Object o = this.buildPluginInstance(cpart, this.getPluginXml().declareRepositoryProvider.class_);
        if (!(o instanceof AbstractRepositoryProvider)) {
            throw EBuildUtil.newProblem("Build Plugin class not an instanceof " + AbstractRepositoryProvider.class.getName());
        }
        this.repositoryProvider = (AbstractRepositoryProvider)o;
    }

    public boolean isApi() {
        return this.key.universe == null && "ebuild".equals(this.key.org) && this.key.name.startsWith("api");
    }
}

