/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.conf.ConfMapping;
import ebuild.conf.ConfSet;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.CEKey;
import ebuild.core.CPart;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildException;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.Part;
import ebuild.core.Task;
import ebuild.util.CollectionUtil;
import ebuild.util.tuple.Triple;
import ebuild.xml.ModuleXml;
import ebuild.xml.Xml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildPlan
extends BuildPlan {
    private final Map<EKey, Node> nodes = new HashMap<EKey, Node>();
    private final Set<Scope> resolvedScopes = new HashSet<Scope>();
    private Node initialNode;
    public final Set<EKey> excludeDependencies;

    public ModuleBuildPlan(EBuildRunner runner, ILogger logger, Module module, ConfSet confs) {
        super(runner, logger, new CEKey(module.key, confs));
        this.initialNode = this.addNode(module);
        this.initialNode.incomingConfs.put(EKey.newUnversioned(null, "-system-", "-injector-"), confs);
        this.excludeDependencies = CollectionUtil.EMPTY_SET;
    }

    public ModuleBuildPlan(EBuildRunner runner, ILogger logger, Object key, ConfSet confs, Map<Module, Triple<ConfSet, ConfMapping, Boolean>> parts) {
        super(runner, logger, key);
        this.initialNode = new SelectionNode(EKey.newUnversioned(null, "-system-", "-dummy-"));
        this.nodes.put(this.initialNode.key, this.initialNode);
        this.initialNode.incomingConfs.put(EKey.newUnversioned(null, "-system-", "-injector-"), confs);
        this.excludeDependencies = new HashSet<EKey>();
        for (Module m : parts.keySet()) {
            Triple<ConfSet, ConfMapping, Boolean> mconf = parts.get(m);
            ModuleNode mnode = this.addNode(m);
            this.initialNode.addOutgoing(new Outgoing(m.key, mnode, (ConfSet)mconf.a, Scope.MAIN, (ConfMapping)mconf.b));
            if (((Boolean)mconf.c).booleanValue()) continue;
            this.excludeDependencies.add(m.key);
        }
    }

    public Module expectModule() {
        if (this.initialNode instanceof ModuleNode) {
            return ((ModuleNode)this.initialNode).module;
        }
        throw new Error("Plan is ModuleSelection:" + this);
    }

    @Override
    public CPart expectLoneCPart() {
        if (this.initialNode instanceof ModuleNode) {
            return ((ModuleNode)this.initialNode).cpart;
        }
        throw new Error("Plan is ModuleSelection:" + this);
    }

    public Collection<CPart> getPrimaryModules() {
        Map<EKey, Outgoing> os = this.initialNode.outgoing;
        ArrayList<CPart> r = new ArrayList<CPart>(os.size());
        for (EKey ekey : os.keySet()) {
            Outgoing o = os.get(ekey);
            if (o.scope != Scope.MAIN) continue;
            r.add(o.node.cpart);
        }
        return r;
    }

    private boolean hasNode(Module p) {
        return this.nodes.containsKey(p.key);
    }

    private Node getNode(Module p) {
        return this.nodes.get(p.key);
    }

    private ModuleNode addNode(Module p) {
        ModuleNode r = new ModuleNode(p);
        this.nodes.put(r.key, r);
        return r;
    }

    @Override
    public void resolveAndConfigure_(Scope scope, Scope builderScope) throws EBuildException {
        if (this.resolvedScopes.contains(scope)) {
            return;
        }
        for (Scope s = scope; s != null; s = s.getParent()) {
            this.resolvedScopes.add(s);
        }
        this.logger.setProvisionalHeading("\n--- Resolve ---");
        this.initialNode.resolveDependencies();
        this.logger.setProvisionalHeading("\n--- Configure ---");
        this.configure();
    }

    @Override
    protected void resolveBuilders(Scope scope) throws EBuildException {
        this.initialNode.resolveBuilders(scope);
    }

    private void configure() throws EBuildException {
        LinkedList<Node> reverseOrder;
        block3: {
            int sizeBefore;
            int sizeAfter;
            HashSet<Node> nodes = new HashSet<Node>(this.nodes.values());
            reverseOrder = new LinkedList<Node>();
            do {
                sizeBefore = nodes.size();
                Iterator I = nodes.iterator();
                while (I.hasNext()) {
                    Node n = (Node)I.next();
                    if (!n.isConfigurable()) continue;
                    n.configure();
                    I.remove();
                    reverseOrder.addFirst(n);
                    break;
                }
                if ((sizeAfter = nodes.size()) == 0) break block3;
            } while (sizeAfter != sizeBefore);
            throw new Error("Could not configure due to cyclical dependency");
        }
        for (Node n : reverseOrder) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            mn.cpart.setDependencies(mn.newCDependencies());
        }
    }

    @Override
    protected void buildActionList_(ActionQueue queue, Task task) throws Exception {
        this.initialNode.buildActionList(queue, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildActionList(ActionQueue queue, Task task, CPart cpart) throws Exception {
        if (!((EBuildDirectory)cpart.part).isWorkspace()) {
            if (task == Task.eclipse_setup) {
                task = Task.build_release;
            } else if (task == Task.eclipse_unsetup) {
                return;
            }
        }
        EBuildContext.start(((Part)cpart.getPart()).context);
        try {
            ModuleCDependencies mcdeps = (ModuleCDependencies)cpart.getDependencies();
            for (ModuleCDependencies.PartDep pd : mcdeps.parts.values()) {
                if (!task.getScope().includes(pd.scope)) continue;
                this.buildActionList(queue, task, pd.cpart);
            }
        }
        finally {
            EBuildContext.end();
        }
        this.buildActionListForPart(queue, task, cpart);
    }

    private abstract class Node {
        final EKey key;
        final Map<EKey, Node> incoming = new HashMap<EKey, Node>();
        final Map<EKey, ConfSet> incomingConfs = new HashMap<EKey, ConfSet>();
        final Map<EKey, Outgoing> outgoing = new HashMap<EKey, Outgoing>();
        ConfSet conf_node = null;

        Node(EKey key) {
            this.key = key;
        }

        private EKey key() {
            return this.key;
        }

        public void addOutgoing(Outgoing outgoing) {
            this.outgoing.put(outgoing.dkey, outgoing);
            outgoing.node.incoming.put(this.key(), this);
        }

        boolean isConfigured() {
            return this.conf_node != null;
        }

        boolean isConfigurable() {
            for (Node node : this.incoming.values()) {
                if (node.isConfigured()) continue;
                return false;
            }
            return true;
        }

        void resolveDependencies() throws EBuildException {
            for (Outgoing o : this.outgoing.values()) {
                o.node.resolveDependencies();
            }
        }

        void configure() throws EBuildException {
            if (this.incomingConfs.size() == 0) {
                this.conf_node = ConfSet.EMPTY;
                return;
            }
            ConfSet.Builder builder = new ConfSet.Builder();
            for (ConfSet confs : this.incomingConfs.values()) {
                builder.addAll(confs);
            }
            this.conf_node = builder.build();
            for (Outgoing o : this.outgoing.values()) {
                if (!this.conf_node.includesAll(o.selectConfs)) continue;
                ConfSet out = o.mapping.select(this.conf_node);
                o.node.incomingConfs.put(this.key(), out);
            }
        }

        void resolveBuilders(Scope scope) throws EBuildException {
            for (Outgoing o : this.outgoing.values()) {
                if (!scope.includes(o.scope) || !this.conf_node.includesAll(o.selectConfs)) continue;
                o.node.resolveBuilders(scope);
            }
        }

        abstract void buildActionList(ActionQueue var1, Task var2) throws Exception;

        public String toString() {
            return this.key + " " + (this.conf_node == null ? "[unconfigured]" : this.conf_node + "");
        }
    }

    private class ModuleNode
    extends Node {
        final Module module;
        private boolean resolved;
        private CPart cpart;

        public ModuleNode(Module module) {
            super(module.key);
            this.resolved = false;
            this.cpart = null;
            this.module = module;
        }

        private ModuleNode resolveNext(String source, EKey dkey) throws EBuildException {
            Module dmodule = (Module)ModuleBuildPlan.this.resolveElement(this.module.context, source, dkey);
            if (ModuleBuildPlan.this.hasNode(dmodule)) {
                return (ModuleNode)ModuleBuildPlan.this.getNode(dmodule);
            }
            return ModuleBuildPlan.this.addNode(dmodule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resolveDependencies() throws EBuildException {
            if (this.resolved) {
                return;
            }
            this.resolved = true;
            EBuildContext.start(this.module.context);
            try {
                ModuleBuildPlan.this.resolveContext(this.module);
                Iterable<Xml.SelectAndMap> deps = this.module.getDependenciesXml();
                for (Xml.SelectAndMap d : deps) {
                    String source = d.source;
                    if ("system".equals(source)) continue;
                    EKey dkey = this.module.context.newModuleKey(d);
                    ConfSet confs = EBuildUtil.parseConfSet(d.confs);
                    ModuleNode dnode = this.resolveNext(source, dkey);
                    Scope scope = EBuildUtil.getScope(d.scope, Scope.MAIN);
                    ConfMapping mapping = EBuildUtil.parseMapping(d.mapping, ConfMapping.EMPTY);
                    this.addOutgoing(new Outgoing(dkey, dnode, confs, scope, mapping));
                }
            }
            finally {
                EBuildContext.end();
            }
            super.resolveDependencies();
        }

        void configure() throws EBuildException {
            super.configure();
            ModuleBuildPlan.this.logger.log(this.module + " <- " + this.conf_node);
            this.cpart = this.module.getCPart(this.conf_node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModuleCDependencies newCDependencies() throws EBuildException {
            EBuildContext.start(this.module.context);
            try {
                Scope scope;
                ModuleCDependencies dependencies = new ModuleCDependencies(this.module);
                Iterable<Xml.SelectAndMap> ds = this.module.getDependenciesXml();
                for (Xml.SelectAndMap d : ds) {
                    if (!this.conf_node.includesAll(EBuildUtil.parseConfSet(d.confs))) continue;
                    scope = EBuildUtil.getScope(d.scope, Scope.MAIN);
                    EKey dkey = this.module.context.newModuleKey(d);
                    String source = d.source;
                    if ("system".equals(source)) continue;
                    Outgoing outgoing = (Outgoing)this.outgoing.get(dkey);
                    dependencies.addPart(new ModuleCDependencies.PartDep(null, scope, outgoing.node.cpart));
                }
                for (ModuleXml.CheckedIn checkedIn : ((ModuleXml.EbuildModule)this.module.getDeclaration()).dependencies.checkedIns) {
                    if (!this.conf_node.includesAll(EBuildUtil.parseConfSet(checkedIn.confs))) continue;
                    scope = EBuildUtil.getScope(checkedIn.scope, Scope.MAIN);
                    ModuleCDependencies moduleCDependencies = dependencies;
                    moduleCDependencies.getClass();
                    dependencies.addCheckedIn(new ModuleCDependencies.CheckedInDep(moduleCDependencies, null, scope, checkedIn.name, checkedIn.type));
                }
                ModuleCDependencies moduleCDependencies = dependencies;
                return moduleCDependencies;
            }
            finally {
                EBuildContext.end();
            }
        }

        void resolveBuilders(Scope scope) throws EBuildException {
            ModuleBuildPlan.this.resolveBuildersForPart(this.cpart, this.conf_node);
            super.resolveBuilders(scope);
        }

        public void buildActionList(ActionQueue queue, Task task) throws Exception {
            ModuleBuildPlan.this.buildActionList(queue, task, this.cpart);
        }
    }

    private class SelectionNode
    extends Node {
        SelectionNode(EKey key) {
            super(key);
        }

        public void buildActionList(ActionQueue queue, Task task) throws Exception {
            for (Outgoing o : this.outgoing.values()) {
                if (!this.conf_node.includesAll(o.selectConfs)) continue;
                ModuleBuildPlan.this.buildActionList(queue, task, o.node.cpart);
            }
        }
    }

    private static class Outgoing {
        final EKey dkey;
        final ModuleNode node;
        final ConfSet selectConfs;
        final Scope scope;
        final ConfMapping mapping;

        Outgoing(EKey dkey, ModuleNode node, ConfSet selectConfs, Scope scope, ConfMapping mapping) {
            this.dkey = dkey;
            this.node = node;
            this.selectConfs = selectConfs;
            this.scope = scope;
            this.mapping = mapping;
        }
    }
}

