/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.conf.ConfSet;
import ebuild.core.CDependencies;
import ebuild.core.CPart;
import ebuild.core.EBuildException;
import ebuild.core.EKey;
import ebuild.core.Module;
import ebuild.core.ModuleRelease;
import ebuild.core.Part;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCDependencies
extends CDependencies {
    public final Map<EKey, PartDep> parts = new HashMap<EKey, PartDep>();
    public final Map<EKey, CheckedInDep> checkedIns = new HashMap<EKey, CheckedInDep>();
    private final Module module;

    public ModuleCDependencies(Module module) {
        this.module = module;
    }

    public void addPart(PartDep dep) {
        this.parts.put(dep.key, dep);
    }

    public void addCheckedIn(CheckedInDep dep) {
        this.checkedIns.put(dep.key, dep);
    }

    @Override
    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (Module m : this.builders.values()) {
            try {
                r = Math.max(r, m.getCPart(ConfSet.EMPTY).lastModification());
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }
        for (PartDep pd : this.parts.values()) {
            r = Math.max(r, pd.cpart.lastModification());
        }
        for (CheckedInDep cid : this.checkedIns.values()) {
            r = Math.max(r, cid.getFile().lastModified());
        }
        return r;
    }

    public void buildModuleCollection(CollectionUtil.Filter<AbstractDep> inclusionFilter, Collection<IModuleRelease> modules, Collection<PartDep> parts) {
        for (PartDep md : parts) {
            if (!inclusionFilter.accept(md)) continue;
            modules.add((ModuleRelease)md.cpart.release);
            ModuleCDependencies mcdeps = (ModuleCDependencies)md.cpart.getDependencies();
            mcdeps.buildModuleCollection(inclusionFilter, modules, mcdeps.getParts().values());
        }
    }

    public void buildClassPath(Scope scope, Collection<String> elements) {
        Scope s = scope;
        while (s != null) {
            for (PartDep pd : this.getParts().values()) {
                if (pd.scope != s) continue;
                ModuleRelease d = (ModuleRelease)pd.cpart.release;
                d.buildClassPath(scope, elements);
            }
            for (CheckedInDep cid : this.getCheckedIns().values()) {
                if (cid.scope != s) continue;
                elements.add(new File("checkedin/" + cid.key.name).getAbsolutePath());
            }
            s = scope.getParent();
        }
    }

    public Map<EKey, AbstractDep> getAll() {
        HashMap<EKey, AbstractDep> r = new HashMap<EKey, AbstractDep>();
        r.putAll(this.parts);
        return r;
    }

    private boolean isGroup(String lookingFor, String actual) {
        if (actual == null) {
            return false;
        }
        return lookingFor.equals(actual);
    }

    public Map<EKey, PartDep> getParts() {
        return this.parts;
    }

    public Map<EKey, PartDep> getPartsForGroup(String group) {
        HashMap<EKey, PartDep> r = new HashMap<EKey, PartDep>();
        for (EKey key : this.parts.keySet()) {
            PartDep pd = this.parts.get(key);
            if (!this.isGroup(group, pd.group)) continue;
            r.put(key, pd);
        }
        return r;
    }

    public Map<EKey, CheckedInDep> getCheckedIns() {
        return this.checkedIns;
    }

    public Map<EKey, CheckedInDep> getCheckedInsForScope(Scope scope) {
        HashMap<EKey, CheckedInDep> r = new HashMap<EKey, CheckedInDep>();
        for (EKey key : this.checkedIns.keySet()) {
            CheckedInDep ed = this.checkedIns.get(key);
            if (scope != ed.scope) continue;
            r.put(key, ed);
        }
        return r;
    }

    public Collection<IModuleRelease> asCollection(Scope scope) {
        HashSet<IModuleRelease> r = new HashSet<IModuleRelease>(this.parts.size());
        for (Scope s = scope; s != null; s = s.getParent()) {
            for (PartDep pd : this.parts.values()) {
                if (pd.scope != s || pd.cpart.release == null) continue;
                r.add((ModuleRelease)pd.cpart.release);
            }
        }
        return r;
    }

    public class CheckedInDep
    extends AbstractDep {
        String type;

        CheckedInDep(String group, Scope scope, String name, String type) {
            super(group, scope, EKey.newUnversioned("checkedin", null, name));
            this.type = type;
        }

        File getFile() {
            File dir = new File(ModuleCDependencies.this.module.getProjectDirectory(), "checkedin");
            return new File(dir, this.key.name);
        }
    }

    public static class PartDep
    extends AbstractDep {
        public final CPart cpart;

        PartDep(String group, Scope scope, CPart cpart) {
            super(group, scope, ((Part)cpart.getPart()).key);
            this.cpart = cpart;
        }
    }

    static abstract class AbstractDep {
        public final String group;
        public final Scope scope;
        public final EKey key;

        AbstractDep(String group, Scope scope, EKey key) {
            this.group = group;
            this.scope = scope;
            this.key = key;
        }
    }
}

