/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.conf.ConfSet;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.BuilderPrototype;
import ebuild.core.CPart;
import ebuild.core.EBuildException;
import ebuild.core.EKey;
import ebuild.core.Module;
import ebuild.core.ModuleBuildProject;
import ebuild.core.ModuleEclipseProject;
import ebuild.core.ModuleRelease;
import ebuild.core.Release;
import ebuild.xml.Xml;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCPart
extends CPart<Module> {
    private BuilderChain buildChain;

    public ModuleCPart(Module module, ConfSet configuration, ConfSet configurationSelected) {
        super(module, configuration, configurationSelected);
    }

    @Override
    ModuleBuildProject newBuildProject() {
        return new ModuleBuildProject((CPart<Module>)this);
    }

    @Override
    ModuleEclipseProject newEclipseProject() {
        return new ModuleEclipseProject((CPart<Module>)this);
    }

    @Override
    Release newRelease() {
        return new ModuleRelease(this.getReleaseDirectory(), this);
    }

    public BuilderChain getBuildChain() {
        return this.buildChain;
    }

    public BuilderChain configureAndParameterizeBuilderChain() throws EBuildException {
        Iterable builderXmls = ((Module)this.part).getProjectHelper().getBuildDependencies(this.getConfiguration());
        ArrayList<BuilderInstance> builders = new ArrayList<BuilderInstance>(builderXmls.size());
        for (Xml.Builder bXml : builderXmls) {
            EKey bkey = ((Module)this.part).getProjectHelper().context.newModuleKey(bXml);
            Module builder = this.getDependencies().builders.get(bkey);
            EKey key_resolved = builder.key;
            BuilderPrototype b = ((Module)this.part).ebuild.expectBuilder(key_resolved);
            builders.add(new BuilderInstance(b, bXml));
        }
        this.buildChain = new BuilderChain(builders);
        return this.buildChain;
    }
}

