/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.conf.ConfSet;
import ebuild.core.BuildPlan;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EBuildException;
import ebuild.core.EBuildMode;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.ProjectHelper;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.Xml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Part<D extends Xml.EBuildPart>
extends Element<D> {
    private final File buildDir;
    private final File releaseDir;
    private final File projectDir;
    public final ElementNature nature;
    private ProjectHelper projectHelper;
    private EclipseProject eclipseProject;
    private Map<ConfSet, CPart> configurations = new HashMap<ConfSet, CPart>();
    private Long lastModified = null;

    public Part(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key);
        this.projectDir = EBuildUtil.canonicalFile(this.getFile(mode == EBuildMode.library ? "project" : "."));
        this.buildDir = EBuildUtil.canonicalFile(this.getFile("build"));
        this.releaseDir = EBuildUtil.canonicalFile(this.getFile("release"));
        this.nature = nature;
        if (nature.isSource()) {
            this.projectHelper = this.newProjectHelper();
        }
    }

    public long lastModificationOfSource() {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            File[] fs = this.getProjectDirectory().listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (!f.getName().startsWith("src")) continue;
                    r = Math.max(r, FileUtil.deepLastModified(f));
                }
                r = Math.max(r, FileUtil.deepLastModified(this.getMetaDirectory()));
            } else {
                r = Long.MAX_VALUE;
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }

    @Override
    public void setRepository(IRepository repository) {
        super.setRepository(repository);
        if (this.isSource()) {
            this.getProjectHelper().context.addRepository("local", repository, this.key.org);
        }
    }

    public boolean hasBuildDirectory() {
        return this.buildDir.exists();
    }

    public File getBuildDirectory() {
        return this.buildDir;
    }

    public boolean hasReleaseDirectory() {
        return this.releaseDir.exists();
    }

    public File getReleaseDirectory() {
        return this.releaseDir;
    }

    public boolean hasProjectDirectory() {
        return this.projectDir.exists();
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public boolean buildIsClean() {
        return !this.hasBuildDirectory() && !this.hasReleaseDirectory();
    }

    public void buildClean() {
        FileUtil.deleteDir(this.getBuildDirectory());
        FileUtil.deleteDir(this.getReleaseDirectory());
    }

    abstract CPart newCPart(ConfSet var1, ConfSet var2);

    abstract BuildPlan newBuildPlan(EBuildRunner var1, ConfSet var2, ILogger var3) throws EBuildException;

    public abstract ProjectHelper newProjectHelper() throws EBuildException;

    public ProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    private ConfSet actualConfiguration(ConfSet configurationSelected) throws EBuildException {
        Map<String, ConfSet> aliases = this.getAliases();
        ConfSet configuration = configurationSelected;
        if (aliases.size() > 0) {
            ConfSet.Builder b = new ConfSet.Builder();
            for (String c : configurationSelected.values()) {
                if (aliases.containsKey(c)) {
                    b.addAll(aliases.get(c));
                    continue;
                }
                b.add(c);
            }
            configuration = b.build();
        }
        return configuration;
    }

    public Set<String> listCheckedIn() {
        File dir = this.getFile("checkedin");
        if (!dir.isDirectory()) {
            return CollectionUtil.EMPTY_SET;
        }
        String[] fs = dir.list();
        HashSet<String> r = new HashSet<String>(fs.length);
        for (String f : fs) {
            r.add(f);
        }
        return r;
    }

    public CPart getCPart(ConfSet configurationSelected) throws EBuildException {
        ConfSet configuration = this.actualConfiguration(configurationSelected);
        CPart r = this.configurations.get(configuration);
        if (r == null) {
            r = this.newCPart(configuration, configurationSelected);
            this.configurations.put(configuration, r);
        }
        return r;
    }

    public EclipseProject createEclipseProject(CPart cpart) {
        if (this.eclipseProject == null) {
            this.eclipseProject = cpart.newEclipseProject();
            try {
                this.eclipseProject.storeConfiguration();
            }
            catch (IOException e) {
                throw new Error("Unable to store configuration", e);
            }
            return this.eclipseProject;
        }
        if (cpart.getConfiguration().equals(this.eclipseProject.getConfiguration())) {
            return this.eclipseProject;
        }
        throw new Error("Attempted to have eclipse project for '" + this.key + "'with 2 different configurations: " + "\n" + cpart.getConfiguration() + "\n" + this.eclipseProject.getConfiguration());
    }

    public EclipseProject expectEclipseProject() {
        if (this.eclipseProject == null) {
            throw new RuntimeException("No eclipse project for " + this.key);
        }
        return this.eclipseProject;
    }

    Map<String, ConfSet> getAliases() throws EBuildException {
        HashMap<String, ConfSet> r = new HashMap<String, ConfSet>();
        for (Xml.Configuration c : ((Xml.EBuildPart)this.getDeclaration()).configurations) {
            if (c.aliases == null) continue;
            ConfSet confs = EBuildUtil.parseConfSet(c.aliases);
            r.put(c.name, confs);
        }
        return r;
    }

    public Collection<String> getConfsNotUsedInName() {
        ArrayList<String> r = new ArrayList<String>();
        for (Xml.Configuration c : ((Xml.EBuildPart)this.getDeclaration()).configurations) {
            if (c.useInName != Boolean.FALSE) continue;
            r.add(c.name);
        }
        return r;
    }

    public boolean isSource() {
        return this.nature.isSource();
    }

    public void addIgnores(List<String> patterns) {
        if (!this.isWorkspace()) {
            throw new Error("Tryed to add a ignores to a non-workspace part: " + this);
        }
        AbstractWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            return;
        }
        wc.addIgnores(patterns);
    }

    public void addIgnores(String ... patterns) {
        this.addIgnores(CollectionUtil.newList(patterns));
    }

    public Date getLastCommitDate() {
        if (this.isWorkspace()) {
            return new Date();
        }
        Date r = FileUtil.readTimestampFile(this.getMetaDirectory());
        if (r == null) {
            r = new Date(this.getProjectDirectory().lastModified());
        }
        return r;
    }
}

