/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.ElementNature;
import ebuild.util.WorkMarker;
import java.io.File;

public class RepositoryContext {
    public final IRepository repo;

    public RepositoryContext(IRepository repo) {
        this.repo = repo;
    }

    public IRepository expectRepo(EKey key) throws EBuildException {
        if (this.repo == null) {
            throw EBuildUtil.newProblem("Repository cannot be located for part: " + key);
        }
        return this.repo;
    }

    public AbstractSourceRepository expectSourceRepo(EKey key) throws EBuildException {
        IRepository r = this.expectRepo(key);
        if (!(r instanceof AbstractSourceRepository)) {
            throw EBuildUtil.newProblem("Not a source repository for part '" + key + "': " + r.getUri());
        }
        return (AbstractSourceRepository)r;
    }

    public String getUniverse() {
        String r = null;
        if (this.repo != null) {
            r = this.repo.getUniverse();
        }
        if (r == null) {
            r = "ebuild";
        }
        return r;
    }

    public void fetchMeta(EKey key, File dir4version) throws EBuildException {
        File dir4meta = new File(dir4version, "meta");
        WorkMarker marker = new WorkMarker(dir4meta);
        if (!marker.isComplete()) {
            IRepository repo = this.expectRepo(key);
            marker.create();
            try {
                repo.fetchMeta(dir4meta, key);
            }
            catch (RepositoryPluginException e) {
                throw EBuildUtil.wrapPluginException("Could not fetch meta for '" + key + "'", e);
            }
            marker.remove();
        }
    }

    public ElementNature determineNature(EKey key, File dir4version) throws EBuildException {
        if (new File(dir4version, "project").exists()) {
            return ElementNature.source;
        }
        if (new File(dir4version, "release").exists()) {
            return ElementNature.binary;
        }
        IRepository repo = this.expectRepo(key);
        if (repo instanceof AbstractSourceRepository) {
            return ElementNature.source;
        }
        return ElementNature.binary;
    }
}

