/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.IVersion;
import ebuild.core.EBuildException;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;

public class Version
implements IVersion {
    private final String branch;
    private final String version;

    public static Version newTag(String version) throws EBuildException {
        return new Version(null, version);
    }

    public static Version newRevision(String revision) {
        return Version.newRevision("trunk", revision);
    }

    public static Version newRevision(String branch, String revision) {
        if (StringUtil.isEmptyString(branch)) {
            branch = "trunk";
        }
        if (StringUtil.isEmptyString(revision)) {
            revision = "head";
        }
        return new Version(branch, revision);
    }

    private Version(String branch, String version) {
        this.branch = branch;
        this.version = version;
    }

    public Version withRevision(String revision) {
        String branch = this.branch;
        if (branch == null) {
            branch = "trunk";
        }
        return new Version(branch, revision);
    }

    public boolean isTag() {
        return this.branch == null;
    }

    public boolean isWorking() {
        return "working".equals(this.version);
    }

    public boolean isHead() {
        return "head".equals(this.getRevision());
    }

    public boolean isMoving() {
        return this.isHead() || this.isWorking();
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRevision() {
        return this.isTag() ? null : this.version;
    }

    public String getTag() {
        return this.isTag() ? this.version : null;
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.branch) + ObjectUtil.hashOf(this.version);
    }

    public boolean equals(Object obj) {
        Version b = (Version)obj;
        return ObjectUtil.areEqual(this.branch, b.branch) && ObjectUtil.areEqual(this.version, b.version);
    }

    public String toString() {
        if (!this.isTag()) {
            String r = "rev_" + this.getRevision();
            if (!"trunk".equals(this.branch)) {
                r = "branch_" + this.branch + "-" + r;
            }
            return r;
        }
        return this.version;
    }
}

