/*
 * Decompiled with CFR 0.152.
 */
package ebuild.options;

import ebuild.options.DisplayOrder;
import ebuild.options.Required;
import ebuild.util.CollectionUtil;
import ebuild.util.SafeCallable;
import ebuild.util.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsUtil {
    public static boolean isPrintOptions(String[] args) {
        return args.length >= 1 && "?".equals(args[0]);
    }

    public static Object getValue(Object optionsObj, String fieldName) {
        Class<?> optionsClass = optionsObj.getClass();
        try {
            Field field = optionsClass.getField(fieldName);
            return field.get(optionsObj);
        }
        catch (NoSuchFieldException e) {
            throw new Error("No such field: " + fieldName);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static Object newDefault(Class optionsClass) {
        try {
            return optionsClass.newInstance();
        }
        catch (Exception e) {
            throw new Error("Could not instantiate options object", e);
        }
    }

    private static Collection<String> required(Class optionsClass) {
        Field[] fields;
        HashSet<String> r = new HashSet<String>();
        for (Field f : fields = optionsClass.getFields()) {
            if (f.getAnnotation(Required.class) == null) continue;
            r.add(f.getName());
        }
        return r;
    }

    private static List<Field> displayOrder(Class optionsClass, CollectionUtil.Filter<String> filter) {
        DisplayOrder displayOrderAnnotation = optionsClass.getAnnotation(DisplayOrder.class);
        String[] displayOrder = new String[]{};
        if (displayOrderAnnotation != null) {
            displayOrder = displayOrderAnnotation.value();
        }
        Field[] fields = optionsClass.getFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<Field> r = new ArrayList<Field>(displayOrder.length + fields.length);
        HashSet<Field> done = new HashSet<Field>(displayOrder.length);
        for (String fieldName : displayOrder) {
            if ("".equals(fieldName)) {
                r.add(null);
                continue;
            }
            if (!filter.accept(fieldName)) continue;
            try {
                Field f = optionsClass.getField(fieldName);
                r.add(f);
                done.add(f);
            }
            catch (Exception e) {
                throw new Error("No such field '" + fieldName + "'", e);
            }
        }
        if (displayOrder.length > 0 && fields.length > 0) {
            r.add(null);
        }
        for (Field f : fields) {
            if (!filter.accept(f.getName()) || done.contains(f)) continue;
            r.add(f);
        }
        return r;
    }

    public static String formatOptions(Class optionsClass) {
        return OptionsUtil.formatOptions(optionsClass, CollectionUtil.ACCEPT_ALL);
    }

    public static String formatOptions(final Class optionsClass, final CollectionUtil.Filter<String> filter) {
        final Object optionsDefault = OptionsUtil.newDefault(optionsClass);
        final StringBuilder sb = new StringBuilder();
        sb.append("Available Options:-\n");
        return new SafeCallable<String>(){

            @Override
            public String run() {
                List displayOrder = OptionsUtil.displayOrder(optionsClass, filter);
                boolean seperate = false;
                for (Field f : displayOrder) {
                    if (f == null) {
                        seperate = true;
                        continue;
                    }
                    if (seperate) {
                        sb.append("\n");
                        seperate = false;
                    }
                    this.format(f);
                }
                return sb.toString();
            }

            public boolean format(Field f) {
                try {
                    Object default_ = f.get(optionsDefault);
                    if (!filter.accept(f.getName())) {
                        return false;
                    }
                    sb.append(StringUtil.lpad(20, StringUtil.camelCaseToDashed(f.getName())));
                    sb.append("=<" + f.getType().getSimpleName() + ">");
                    if (f.getAnnotation(Required.class) != null) {
                        sb.append("*");
                    } else if (!StringUtil.isEmptyString(default_)) {
                        sb.append("/" + default_);
                    }
                    sb.append("\n");
                    return true;
                }
                catch (Exception e) {
                    throw new Error("Unable to format option field '" + f.getName() + "'", e);
                }
            }
        }.run();
    }

    public static String formatOptionValues(Object optionsObj) {
        return OptionsUtil.formatOptionValues(optionsObj, CollectionUtil.ACCEPT_ALL);
    }

    public static String formatOptionValues(final Object optionsObj, final CollectionUtil.Filter<String> filter) {
        final Class<?> optionsClass = optionsObj.getClass();
        return new SafeCallable<String>(){
            StringBuilder sb = new StringBuilder();

            @Override
            public String run() {
                List displayOrder = OptionsUtil.displayOrder(optionsClass, filter);
                boolean seperate = false;
                for (Field f : displayOrder) {
                    if (f == null) {
                        seperate = true;
                        continue;
                    }
                    if (seperate) {
                        this.sb.append("////\n");
                        seperate = false;
                    }
                    this.format(f);
                }
                return this.sb.toString();
            }

            public void format(Field f) {
                try {
                    Object v = f.get(optionsObj);
                    this.sb.append("//// ");
                    this.sb.append(StringUtil.lpad(20, StringUtil.camelCaseToDashed(f.getName())));
                    this.sb.append(": ");
                    this.sb.append("" + v);
                    this.sb.append("\n");
                }
                catch (Exception e) {
                    throw new Error("Unable to format option field '" + f.getName() + "'", e);
                }
            }
        }.run();
    }

    public static List<String> interpret(final Object optionsObj, final String[] args) {
        final Class<?> optionsClass = optionsObj.getClass();
        return new SafeCallable<List<String>>(){
            List<String> errors = new LinkedList<String>();
            Set<String> keys = new HashSet<String>(args.length);

            @Override
            public List<String> run() throws RuntimeException {
                for (String s : args) {
                    String key;
                    String[] ss = s.split("=", 2);
                    if (ss.length == 1) {
                        key = ss[0];
                        this.translate(StringUtil.camelCaseFromDashed(key), "true");
                        continue;
                    }
                    if (ss.length == 2) {
                        key = ss[0];
                        String value = ss[1];
                        this.translate(StringUtil.camelCaseFromDashed(key), value);
                        continue;
                    }
                    this.errors.add("Properties should be supplied as arguments of the form {key}={value}, got: " + s);
                }
                Collection missing = OptionsUtil.required(optionsClass);
                missing.removeAll(this.keys);
                for (String key : missing) {
                    this.errors.add("Required field '" + key + "' not set");
                }
                return this.errors;
            }

            private void translate(String key, String value) {
                block10: {
                    boolean hasValue;
                    Field f;
                    try {
                        f = optionsClass.getField(key);
                    }
                    catch (NoSuchFieldException e) {
                        this.errors.add("Invalid configuration property: " + key);
                        return;
                    }
                    boolean bl = hasValue = !StringUtil.isEmptyString(value);
                    if (!hasValue) {
                        return;
                    }
                    this.keys.add(key);
                    try {
                        Class<Enum> type = f.getType();
                        if (Boolean.TYPE == type) {
                            boolean b = Boolean.parseBoolean(value);
                            f.setBoolean(optionsObj, b);
                            break block10;
                        }
                        if (Integer.TYPE == type) {
                            int i = Integer.parseInt(value);
                            f.setInt(optionsObj, i);
                            break block10;
                        }
                        if (type.isEnum()) {
                            this.setEnum(type, f, value);
                            break block10;
                        }
                        if (File.class == type) {
                            f.set(optionsObj, new File(value));
                            break block10;
                        }
                        if (String.class == type) {
                            f.set(optionsObj, value);
                            break block10;
                        }
                        throw new Error("Unsupported type: " + type.getName());
                    }
                    catch (Exception e) {
                        this.errors.add(e.getMessage());
                    }
                }
            }

            private void setEnum(Class<Enum> enumClass, Field f, String value) throws IllegalAccessException {
                for (Enum e : enumClass.getEnumConstants()) {
                    if (!e.name().equals(value)) continue;
                    f.set(optionsObj, e);
                    return;
                }
                String list = StringUtil.join(",", enumClass.getEnumConstants());
                this.errors.add("Expected one of '" + list + "' property '" + f.getName() + "'");
            }
        }.run();
    }
}

