/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class Directory {
    public final File f;

    public Directory(File f) {
        this.f = f;
    }

    public void mkdirs() throws IOException {
        if (!this.f.isDirectory() && !this.f.mkdirs()) {
            throw new IOException("Unable to make dirs: " + this.f);
        }
    }

    public File javaFile() {
        return this.f;
    }

    public String getName() {
        return this.f.getName();
    }

    public File getFile(String name) {
        return new File(this.f, name);
    }

    public boolean hasFile(String path) {
        return this.getFile(path).exists();
    }

    public Reader readFile(String name) throws IOException {
        File f = this.getFile(name);
        if (!f.isFile()) {
            throw new IOException(f + " does not exist");
        }
        return new FileReader(f);
    }
}

