/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.core.EBuildException;
import ebuild.core.EBuildUtil;
import ebuild.util.StringUtil;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTemplate {
    private final List<Token> tokens;

    public NameTemplate(List<Token> tokens) {
        this.tokens = tokens;
    }

    public boolean hasVar(String name) {
        for (Token t : this.tokens) {
            if (!(t instanceof Token.Var) || !name.equals(((Token.Var)t).name)) continue;
            return true;
        }
        return false;
    }

    public void append(NameTemplate s) {
        this.tokens.addAll(s.tokens);
    }

    public void appendVar(String prefix, String name) {
        this.tokens.add(new Token.Var(prefix, name));
    }

    public void appendText(String name) {
        this.tokens.add(new Token.Text(name));
    }

    public String apply(Model model) {
        StringBuilder sb = new StringBuilder();
        for (Token t : this.tokens) {
            t.process(sb, model);
        }
        return sb.toString();
    }

    public static NameTemplate parse(String template) throws EBuildException {
        try {
            Parser p = new Parser(new StringReader(template));
            p.parse();
            return new NameTemplate(p.tokens);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (ParseException e) {
            throw EBuildUtil.newProblem("Invalid expression '" + template + "': " + e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parser {
        private final List<Token> tokens = new LinkedList<Token>();
        private final PushbackReader reader;
        private StringBuilder acc = new StringBuilder();

        Parser(Reader r) {
            this.reader = new PushbackReader(r);
        }

        private int read() throws IOException {
            return this.reader.read();
        }

        private int peek() throws IOException {
            int c = this.read();
            this.reader.unread(c);
            return c;
        }

        private void unread(int i) throws IOException {
            if (i != -1) {
                this.reader.unread(i);
            }
        }

        private ParseException e(String msg) {
            return new ParseException(msg);
        }

        List<Token> parse() throws IOException, ParseException {
            int c;
            while ((c = this.peek()) != -1) {
                this.tokens.add(this.parseTextOrVar((char)c));
            }
            return this.tokens;
        }

        private Token parseTextOrVar(char c) throws IOException, ParseException {
            if (c == '{') {
                return this.parseVar();
            }
            return this.parseText();
        }

        private Token parseText() throws IOException {
            this.acc.setLength(0);
            while (true) {
                int c;
                if ((c = this.read()) == -1 || c == 123) {
                    this.unread(c);
                    return new Token.Text(this.acc.toString());
                }
                this.acc.append((char)c);
            }
        }

        private Token parseVar() throws IOException, ParseException {
            this.acc.setLength(0);
            int c = this.read();
            assert (123 == c);
            while (true) {
                if ((c = this.read()) == -1) {
                    throw this.e("Unterminated variable: {" + this.acc.toString());
                }
                if (c == 125) {
                    return new Token.Var(null, this.acc.toString());
                }
                if (c == 124) {
                    return this.parseVarAfterPrefix(this.acc.toString());
                }
                this.acc.append((char)c);
            }
        }

        private Token parseVarAfterPrefix(String prefix) throws IOException, ParseException {
            this.acc.setLength(0);
            while (true) {
                int c;
                if ((c = this.read()) == -1) {
                    throw this.e("Unterminated variable: {" + prefix + "|" + this.acc.toString());
                }
                if (c == 125) {
                    return new Token.Var(prefix, this.acc.toString());
                }
                this.acc.append((char)c);
            }
        }
    }

    private static class ParseException
    extends Exception {
        ParseException(String msg) {
            super(msg);
        }
    }

    private static abstract class Token {
        private Token() {
        }

        public abstract void process(StringBuilder var1, Model var2);

        static class Var
        extends Token {
            final String prefix;
            final String name;

            Var(String prefix, String name) {
                this.prefix = prefix;
                this.name = name;
            }

            public void process(StringBuilder sb, Model model) {
                String value = model.getValue(this.name);
                if (!StringUtil.isEmptyString(value)) {
                    if (this.prefix != null) {
                        sb.append(this.prefix);
                    }
                    sb.append(value);
                }
            }

            public String toString() {
                if (this.prefix == null) {
                    return "(V){" + this.name + "}";
                }
                return "(V){" + this.prefix + "|" + this.name + "}";
            }
        }

        static class Text
        extends Token {
            final String value;

            Text(String value) {
                this.value = value;
            }

            public void process(StringBuilder sb, Model model) {
                sb.append(this.value);
            }

            public String toString() {
                return "(T)" + this.value;
            }
        }
    }

    public static interface Model {
        public String getValue(String var1);
    }
}

