/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObject<K, V> {
    private PObject<K, V>[] prototypes = new PObject[0];
    final Map<K, V> values = new HashMap();

    protected boolean cache() {
        return true;
    }

    public void addPrototypes(PObject<K, V>[] ps) {
        PObject<K, V>[] old = this.prototypes;
        this.prototypes = new PObject[this.prototypes.length + ps.length];
        System.arraycopy(old, 0, this.prototypes, 0, old.length);
        System.arraycopy(ps, 0, this.prototypes, old.length, ps.length);
    }

    public K reverseLookup(V lookup) {
        for (K k : this.values.keySet()) {
            V v = this.values.get(k);
            if (v != lookup) continue;
            return k;
        }
        return this.reverseLookupPrevious(lookup);
    }

    public K reverseLookupPrevious(V lookup) {
        for (PObject<K, V> p : this.prototypes) {
            K r = p.reverseLookup(lookup);
            if (r == null) continue;
            if (this.cache()) {
                this.values.put(r, lookup);
            }
            return r;
        }
        return null;
    }

    public V get(K key) {
        V r = this.getOur(key);
        if (r != null) {
            return r;
        }
        return this.getPrevious(key);
    }

    public V getOur(K key) {
        return this.values.get(key);
    }

    public V getPrevious(K key) {
        for (PObject<K, V> p : this.prototypes) {
            V r = p.get(key);
            if (r == null) continue;
            if (this.cache()) {
                this.values.put(key, r);
            }
            return r;
        }
        return null;
    }

    public void put(K key, V value) {
        this.values.put(key, value);
    }

    private void format(String prepend, StringBuilder sb) {
        sb.append(prepend + this.values + "\n");
        String prepend2 = "  " + prepend;
        for (PObject<K, V> p : this.prototypes) {
            super.format(prepend2, sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.format("", sb);
        return sb.toString();
    }
}

