/*
 * Decompiled with CFR 0.152.
 */
package ebuild;

import ebuild.api.common.ElementType;
import ebuild.core.ComponentRelease;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.util.EBuildException;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoWorkspace
extends EBuildRunner {
    final Options options;

    public static void main(String[] args) throws Exception {
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(Options.class));
        } else {
            System.err.println("Pass argument ? to print out options");
            Options options = new Options();
            HashSet<String> optionSet = new HashSet<String>();
            List<String> errors = OptionsUtil.interpret(options, args, optionSet);
            if (!options.home.exists()) {
                errors.add("_ebuild directory does not exist: " + FileUtil.canonicalFile(options.home));
            }
            if (errors.size() > 0) {
                for (String e : errors) {
                    System.err.println(e);
                }
                System.exit(1);
            }
            DoWorkspace doWorkspace = new DoWorkspace(options);
            doWorkspace.formatOptionValues(optionSet);
            doWorkspace.run();
        }
    }

    public DoWorkspace(Options options) {
        super(options);
        this.options = options;
    }

    private void formatOptionValues(final Set<String> set) {
        this.log("////////////////////////////////////////////////////////////");
        this.log(OptionsUtil.formatOptionValues((Object)this.options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(DoWorkspace.this.options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return DoWorkspace.this.options.debug;
                }
                return set.contains(f);
            }
        }));
        this.log("////////////////////////////////////////////////////////////");
        this.log("");
    }

    @Override
    public void go() throws Exception {
        Task task = this.options.task;
        File projectDir = FileUtil.canonicalFile(this.ebuild.getProjectInWorkspace(this.options.project));
        Element part = this.resolveFirst(projectDir);
        this.go(part, this.options.confs, task);
        File copyTo = this.options.mergeReleaseTo;
        if (copyTo != null) {
            if (task == Task.build_release && part.key.type == ElementType.component) {
                this.log("// Merging release to: " + this.ebuild.formatAsDisplayPath(copyTo));
                ComponentRelease release = (ComponentRelease)this.principalRelease.release;
                FileUtil.mergeCopy(release.getFile(), copyTo);
            } else {
                this.log("// IGNORING option merge-release-to - only applies when task==build_release and element is a component");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element resolveFirst(File projectDir) throws EBuildException {
        EBuildContext.start(this.ebuild.context);
        try {
            EKey partKey = EKey.newWorkingKey(null, projectDir);
            Element r = this.ebuild.resolveWorkspaceElement(partKey);
            if (r == null) {
                this.log("Not an ebuild project.");
                System.exit(1);
            }
            Element element = r;
            return element;
        }
        finally {
            EBuildContext.end();
        }
    }

    @DisplayOrder(value={"task", "confs", "project", ""})
    public static class Options
    extends EBuild.Options {
        public Task task = Task.eclipse_setup;
        public String confs = "";
        public String project = FileUtil.canonicalFile(new File(".")).getName();
        public File mergeReleaseTo = null;
    }
}

