/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.CPart;
import ebuild.core.ComponentCPart;
import ebuild.core.EBuildRunner;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.util.WorkMarker;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;

public abstract class Action {
    public final ActionStatus status;
    public final Element part;
    public final CPart cpart;

    private static ActionStatus marker2status(WorkMarker marker) {
        if (marker.isInProgress()) {
            return ActionStatus.dirty;
        }
        if (marker.isComplete()) {
            return ActionStatus.done;
        }
        return ActionStatus.todo;
    }

    private Action(ActionStatus status, Element part, CPart cpart) {
        this.status = status;
        this.part = part;
        this.cpart = cpart;
    }

    public Action(WorkMarker marker, Element part, CPart cpart) {
        this(Action.marker2status(marker), part, cpart);
    }

    public Action(ActionStatus status, CPart cpart) {
        this(status, (Element)cpart.part, cpart);
    }

    public abstract String getDisplayName();

    public abstract void run_(ILogger var1) throws Exception;

    public void finish(boolean skipped) throws Exception {
    }

    public final void run(ILogger logger) throws Exception {
        this.run_(logger);
        this.finish(false);
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.part) + ObjectUtil.hashOf(this.cpart);
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action b = (Action)obj;
        if (!this.part.equals(b.part)) {
            return false;
        }
        return ObjectUtil.areEqual(this.cpart, b.cpart);
    }

    public String format() {
        return StringUtil.rpad(16, this.getDisplayName()) + " " + this.part.key.toString() + (this.cpart == null ? "" : " " + this.cpart.configuration);
    }

    public String toString() {
        return this.format();
    }

    static class BuildClean
    extends Action {
        public BuildClean(ActionStatus status, CPart cpart) {
            super(status, cpart);
        }

        public String getDisplayName() {
            return "build clean";
        }

        public void run_(ILogger logger) throws Exception {
            this.part.buildClean();
        }
    }

    static class BuildRelease
    extends Action {
        final EBuildRunner runner;

        public BuildRelease(ActionStatus status, CPart cpart, EBuildRunner runner) {
            super(status, cpart);
            this.runner = runner;
        }

        public String getDisplayName() {
            return "build release";
        }

        public void run_(ILogger logger) throws Exception {
            BuildProject proj = this.cpart.build;
            if (this.status == ActionStatus.dirty) {
                proj.clean();
            }
            proj.build();
        }

        public void finish(boolean skipped) throws Exception {
            this.cpart.registerRelease();
            this.runner.releases.add(this.cpart);
        }
    }

    static class EclipseUnsetup
    extends Action {
        public EclipseUnsetup(ActionStatus status, CPart cpart) {
            super(status, cpart);
        }

        public String getDisplayName() {
            return "eclipse unsetup";
        }

        public void run_(ILogger logger) throws Exception {
            this.cpart.eclipse.unsetup();
        }
    }

    static class EclipseSetup
    extends Action {
        public EclipseSetup(ActionStatus status, CPart cpart) {
            super(status, cpart);
        }

        public String getDisplayName() {
            return "eclipse setup";
        }

        public void run_(ILogger logger) throws Exception {
            EclipseProject proj = this.cpart.eclipse;
            if (this.status == ActionStatus.dirty) {
                proj.unsetup();
            }
            proj.setup();
        }
    }

    static class FetchArtifacts
    extends Action {
        final WorkMarker marker;

        public FetchArtifacts(WorkMarker marker, CPart cpart) {
            super(marker, (Element)cpart.part, cpart);
            this.marker = marker;
        }

        public String getDisplayName() {
            return "fetch artifacts";
        }

        public void run_(ILogger logger) throws Exception {
            this.marker.create();
            AbstractReleaseRepository repo = (AbstractReleaseRepository)this.part.getRepository();
            if (((Element)this.cpart.part).key.type == ElementType.module) {
                File dir = new File(this.cpart.getReleaseDirectory(), "/main");
                repo.fetchModuleRelease(dir, this.part.key, this.cpart.configuration);
            } else {
                String filename = ((ComponentCPart)this.cpart).releaseFileName();
                repo.fetchComponentRelease(this.part.getReleaseDirectory(), this.part.key, filename);
            }
            this.marker.remove();
        }

        public void finish(boolean skipped) throws Exception {
            this.cpart.registerRelease();
        }
    }

    static class FetchSource
    extends Action {
        final WorkMarker marker;

        public FetchSource(WorkMarker marker, Element part) {
            super(marker, part, null);
            this.marker = marker;
        }

        public String getDisplayName() {
            return "fetch source";
        }

        public void run_(ILogger logger) throws Exception {
            assert (!this.part.isWorkspace());
            this.marker.create();
            logger.log(this.part.key.fullnameAndVersionAndUniverse() + " -> fetching source");
            AbstractSourceRepository repo = (AbstractSourceRepository)this.part.getRepository();
            repo.fetchProject(this.part.getProjectDirectory(), this.part.key);
            this.marker.remove();
        }
    }
}

