/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.repo.IRepository;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.BuildResolutionReport;
import ebuild.core.CDependencies;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.CEKey;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.util.EBuildException;
import ebuild.core.util.WorkMarker;
import ebuild.util.tuple.Pair;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BuildPlan {
    final EBuild ebuild;
    final EBuildRunner runner;
    final BuildResolutionReport report;
    final Object key;
    protected final Set<Object> builderPlans = new LinkedHashSet<Object>();
    private Set<Pair<EKey, EKey>> resolved = new HashSet<Pair<EKey, EKey>>();

    public BuildPlan(EBuildRunner runner, Object key) {
        this.ebuild = runner.ebuild;
        this.runner = runner;
        this.report = runner.report;
        this.key = key;
        runner.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    public abstract CPart expectLoneCPart() throws EBuildException;

    protected abstract void resolveBuilders(Scope var1) throws EBuildException;

    protected abstract void resolveAndConfigure_(Scope var1, Scope var2) throws EBuildException;

    protected abstract void buildActionList_(ActionQueue var1, Task var2) throws Exception;

    public void resolveAndConfigure(Scope scope, Scope builderScope) throws EBuildException {
        this.report.startPlan(this, scope);
        this.resolveAndConfigure_(scope, builderScope);
        this.report.startResolveBuilders();
        this.resolveBuilders(scope);
        this.report.endResolveBuilders();
        for (Object subKey : this.builderPlans) {
            ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(subKey);
            subPlan.resolveAndConfigure(builderScope, builderScope);
        }
        this.report.endPlan();
    }

    public void buildActionList(ActionQueue queue, Task task) throws Exception {
        for (Object subKey : this.builderPlans) {
            BuildPlan subPlan = this.runner.buildPlans.get(subKey);
            subPlan.buildActionList(queue, task);
            if (task != Task.eclipse_setup || !(this instanceof ModuleBuildPlan)) continue;
            subPlan.buildActionList(queue, Task.build_release);
        }
        this.buildActionList_(queue, task);
    }

    protected void buildActionListForPart(ActionQueue queue, Task task, CPart cpart) throws Exception {
        Object part = cpart.getPart();
        if (!((Element)part).isWorkspace()) {
            if (((Element)part).isSource()) {
                WorkMarker marker = new WorkMarker(((Element)part).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Element)part);
                queue.add(action);
            } else {
                String confDir = cpart.configuration.asDirectoryName();
                WorkMarker marker = new WorkMarker(new File(((Element)part).getReleaseDirectory(), confDir));
                queue.add(new Action.FetchArtifacts(marker, cpart));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library part: " + cpart);
            }
            if (task == Task.fetch_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Element)part).isSource()) break;
                BuildProject bproject = cpart.createBuildProject();
                ActionStatus status = bproject.isDirty() ? ActionStatus.dirty : (bproject.isClean() ? ActionStatus.todo : ActionStatus.done);
                queue.add(new Action.BuildRelease(status, cpart, this.runner));
                break;
            }
            case build_clean: {
                if (!((Element)part).isSource()) break;
                ActionStatus status = ((Element)part).buildIsClean() ? ActionStatus.done : ActionStatus.todo;
                queue.add(new Action.BuildClean(status, cpart));
                break;
            }
            case eclipse_setup: {
                if (!((Element)part).isWorkspace()) break;
                EclipseProject eproject = cpart.createEclipseProject();
                ActionStatus status = eproject.isProjectDirty() ? ActionStatus.dirty : ActionStatus.todo;
                queue.add(new Action.EclipseSetup(status, cpart));
                break;
            }
            case eclipse_unsetup: {
                cpart.createEclipseProject();
                ActionStatus status = ActionStatus.todo;
                queue.add(new Action.EclipseUnsetup(status, cpart));
            }
        }
    }

    protected Element resolveElement(EBuildContext from, String source, EKey dkey) throws EBuildException {
        Element r = from.resolveElement(source, dkey);
        Pair<EKey, EKey> res = new Pair<EKey, EKey>(dkey, r.key);
        if (!this.resolved.contains(res)) {
            this.resolved.add(res);
            this.report.resolve((EKey)res.a, (EKey)res.b);
        }
        return r;
    }

    private Module resolveModule(EBuildContext from, Xml.Select d) throws EBuildException {
        EKey dkey = from.newElementKey(ElementType.module, d);
        return (Module)this.resolveElement(from, d.source, dkey);
    }

    protected EBuildContext resolveContext(Element element) throws EBuildException {
        return this.resolveContext(element.context, (Xml.EBuildRoot)element.getDeclaration());
    }

    protected EBuildContext resolveContext(ProjectHelper phelper) throws EBuildException {
        return this.resolveContext(phelper.context, phelper.getBuildXml());
    }

    protected EBuildContext resolveContext(EBuildContext context, Xml.EBuildRoot xml) throws EBuildException {
        for (Xml.Repository repoXml : xml.repositories) {
            IRepository repo = this.ebuild.getRepository(repoXml);
            context.addRepository(repoXml.name, repo, repoXml.org);
        }
        ArrayList<EBuildContext> add = new ArrayList<EBuildContext>(Math.min(1, xml.usings.size()));
        for (Xml.Using d : xml.usings) {
            Module dpart = this.resolveModule(context, d);
            EBuildContext dcontext = d.isBuild() ? this.resolveContext(dpart.expectProjectHelper()) : this.resolveContext(dpart);
            add.add(dcontext);
        }
        if (add.size() == 0) {
            add.add(this.ebuild.context);
        }
        context.init(add);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveBuildersForPart(CPart cpart, ConfSet conf) throws EBuildException {
        Object part = cpart.part;
        if (!((Element)part).isSource()) {
            return;
        }
        ProjectHelper phelper = ((Element)part).getProjectHelper();
        EBuildContext.start(phelper.context);
        try {
            this.resolveContext(phelper);
            CDependencies deps = cpart.getDependencies();
            Iterable<Xml.Select> ds = phelper.getBuildDependencies(conf);
            for (Xml.Select d : ds) {
                EKey bekey = phelper.context.newModuleKey(d);
                CEKey bcekey = new CEKey(bekey, ConfSet.EMPTY);
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(bcekey);
                if (subPlan == null) {
                    Module bpart = (Module)this.resolveElement(phelper.context, d.source, bekey);
                    if (!(bpart instanceof Module)) {
                        throw EBuildException.newProblem("Builder part is not a module, got: " + (Object)((Object)bpart.getType()));
                    }
                    subPlan = new ModuleBuildPlan(this.runner, bpart, ConfSet.EMPTY);
                    this.report.addPlan(subPlan);
                }
                this.builderPlans.add(subPlan.getKey());
                deps.addBuilder(bekey, subPlan.expectModule());
            }
        }
        finally {
            EBuildContext.end();
        }
    }

    public String toString() {
        return this.getKey() + "";
    }
}

