/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.common.ElementType;
import ebuild.api.log.ISwitch;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.core.Component;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.ElementResolver;
import ebuild.core.InstallRepoProvider;
import ebuild.core.Module;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.BuilderPrototype;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.xml.Xml;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuild
implements IEBuild,
ElementResolver {
    public static final Logger ROOT_LOGGER = Logger.newRootLogger();
    private final File home;
    public final EBuildContext context;
    public final Logger logger;
    public final Logger logger_verbose;
    public final Options options;
    private final boolean inferWorkingCopies;
    public final List<File> workspaceDirs;
    private final File libraryDir;
    private final Map<EKey, Element> libraryParts = new HashMap<EKey, Element>();
    private final Map<EKey, Element> workspaceParts = new HashMap<EKey, Element>();
    private final Map<EKey, EKey> workspaceMapping = new HashMap<EKey, EKey>();
    private final Map<EKey, AbstractAssembler> assemblers = new HashMap<EKey, AbstractAssembler>();
    private final Map<EKey, BuilderPrototype> builders = new HashMap<EKey, BuilderPrototype>();
    private final Map<String, AbstractRepositoryProvider> providers = new HashMap<String, AbstractRepositoryProvider>();
    final List<String> builtinRepos = CollectionUtil.newList("public      |http |http://sandbox.emanate5.com:8123/download/0.7/", "maven-public|maven|named://maven-public", "ivy-roundup |ivy  |named://ivy-roundup");

    public EBuild(Options options) {
        this(options, Logger.newRootLogger(), true);
    }

    public EBuild(Options options, Logger logger, boolean inferWorkingCopies) {
        this.home = options.home;
        this.options = options;
        this.logger = logger;
        this.logger_verbose = logger.newSubLogger(new ISwitch(){

            public boolean isOn() {
                return EBuild.this.options.verbose;
            }
        });
        this.inferWorkingCopies = inferWorkingCopies;
        this.workspaceDirs = options.workspaces;
        for (int i = 0; i < this.workspaceDirs.size(); ++i) {
            this.workspaceDirs.set(i, FileUtil.canonicalFile(this.workspaceDirs.get(i)));
        }
        this.libraryDir = FileUtil.canonicalFile(this.getFile("library"));
        this.context = new EBuildContext(this);
        this.providers.put("http", new HttpRepositoryProvider());
        this.addRepos(this.builtinRepos);
        this.addRepos(options.overrideRepositories);
        this.context.addRepository(this.newAliasRepositoryRef("ibiblio", "maven-public"));
        this.context.addRepository(this.newAliasRepositoryRef("ivyroundup", "ivy-roundup"));
    }

    public File getFile(String name) {
        return new File(this.home, name);
    }

    private void addRepos(List<String> repos) {
        for (String value : repos) {
            String[] name_type_url = value.split("\\|", 3);
            if (name_type_url.length != 3) {
                throw new Error("Expected repos to be specified <name>|<type>|<url");
            }
            String name = name_type_url[0].trim();
            String type = name_type_url[1].trim();
            String url = name_type_url[2].trim();
            this.context.addRepository(this.newLazyRepositoryRef(name, type, url));
        }
    }

    private RepositoryRef newLazyRepositoryRef(String name, final String type, final String uri) {
        return new RepositoryRef(this.context, name, null){

            public IRepository getRepository() {
                try {
                    return EBuild.this.getRepository(type, uri);
                }
                catch (EBuildException e) {
                    throw new Error(e);
                }
            }
        };
    }

    private RepositoryRef newAliasRepositoryRef(String name, final String aliased) {
        return new RepositoryRef(this.context, name, null){

            public IRepository getRepository() {
                return this.context.getRepository(aliased).getRepository();
            }
        };
    }

    public Collection<Element> getResolvedLibraryElements() {
        return this.libraryParts.values();
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    @Override
    public String getPathInWorkspace(File f) {
        f = FileUtil.canonicalFile(f);
        String fpath = f.getPath();
        for (int i = 0; i < this.workspaceDirs.size(); ++i) {
            String wpath = this.workspaceDirs.get(i).getPath();
            if (!fpath.startsWith(wpath)) continue;
            return fpath.substring(wpath.length());
        }
        return null;
    }

    @Override
    public String formatAsDisplayPath(File f) {
        String fpath = (f = FileUtil.canonicalFile(f)).getPath();
        if (fpath.startsWith(this.libraryDir.getPath())) {
            return "[library]" + fpath.substring(this.libraryDir.getPath().length());
        }
        for (int i = 0; i < this.workspaceDirs.size(); ++i) {
            String path = this.workspaceDirs.get(i).getPath();
            String name = "[workspace" + (i == 0 ? "" : i + "") + "]";
            if (!fpath.startsWith(path)) continue;
            return name + fpath.substring(path.length());
        }
        return fpath;
    }

    @Override
    public boolean isVerbose() {
        return this.options.verbose;
    }

    public boolean isDEBUG() {
        return this.options.debug;
    }

    public File getLibraryDirectory() {
        return this.libraryDir;
    }

    public File getUniverseDirectory(String universe) {
        return new File(this.libraryDir, universe);
    }

    @Override
    public File getCredentialsFile(String path) {
        return this.getFile("credentials/" + path);
    }

    public void registerBuilder(EKey key, BuilderPrototype builder) {
        this.builders.put(key, builder);
    }

    public void registerBuilder(EKey key, AbstractAssembler assembler) {
        this.assemblers.put(key, assembler);
    }

    public void registerRepositoryProvider(String type, AbstractRepositoryProvider plugin) {
        this.providers.put(type, plugin);
    }

    public BuilderPrototype expectBuilder(EKey key) throws EBuildException {
        BuilderPrototype r = this.builders.get(key);
        if (r == null) {
            throw EBuildException.newProblem("Unknown builder: " + key);
        }
        return r;
    }

    public AbstractAssembler expectAssembler(EKey key) throws EBuildException {
        AbstractAssembler r = this.assemblers.get(key);
        if (r == null) {
            throw EBuildException.newProblem("Unknown assembler: " + key);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element newPart(EBuildMode mode, ElementNature nature, File projectDir, EKey key) throws EBuildException {
        EBuildContext.start(this.context);
        try {
            Element element = this.newElement(mode, projectDir, key, nature);
            return element;
        }
        finally {
            EBuildContext.end();
        }
    }

    private Element newElement(EBuildMode mode, File projectDir, EKey key, ElementNature nature) throws EBuildException {
        Element r = this.newElement_(mode, projectDir, key, nature);
        Xml.EBuildElement declaration = (Xml.EBuildElement)EBuildUtil.parseXml(this, new File(r.getMetaDirectory(), EBuildUtil.elementType2xmlName(key.type)));
        r.initDeclaration(declaration);
        return r;
    }

    private Element newElement_(EBuildMode mode, File projectDir, EKey key, ElementNature nature) throws EBuildException {
        switch (key.type) {
            case component: {
                return new Component(mode, projectDir, this, key, nature);
            }
            case module: {
                return new Module(mode, projectDir, this, key, nature);
            }
        }
        throw new Error("!");
    }

    public EKey remapKey(EKey key) {
        EKey wkey = this.workspaceMapping.get(key);
        if (wkey != null) {
            return wkey;
        }
        return key;
    }

    public File getProjectInWorkspace(String projectName) {
        for (File ws : this.workspaceDirs) {
            File projectDir = new File(ws, projectName);
            if (!projectDir.isDirectory()) continue;
            return projectDir;
        }
        return null;
    }

    public Element newWorkspaceElement(EKey key) throws EBuildException {
        String projectName = key.getDefaultWorkspaceName();
        File projectDir = this.getProjectInWorkspace(projectName);
        if (projectDir != null) {
            EKey wkey = EKey.newWorkingKey(key.type, projectDir);
            this.workspaceMapping.put(key, wkey);
            return this.newPart(EBuildMode.workspace, ElementNature.source, projectDir, wkey);
        }
        return null;
    }

    public boolean hasWorkspaceElement(EKey key) {
        String projectName = key.getDefaultWorkspaceName();
        File projectDir = this.getProjectInWorkspace(projectName);
        return projectDir.exists();
    }

    @Override
    public Element resolveWorkspaceElement(EKey key) throws EBuildException {
        Element r = this.workspaceParts.get(key);
        if (r == null && (r = this.newWorkspaceElement(key)) != null) {
            AbstractWorkingCopy wc = this.inferWorkingCopy(r.javaFile());
            if (wc != null) {
                r.setRepository(wc.getRepository());
                r.setWorkingCopy(wc);
            } else {
                r.setRepository(null);
            }
            this.workspaceParts.put(key, r);
        }
        return r;
    }

    @Override
    public Element resolveLibraryPart(RepositoryContext repoContext, EKey key) throws EBuildException {
        assert (!"workspace".equals(key.version.getRevision()));
        Element r = this.libraryParts.get(key);
        if (r == null) {
            String universe = repoContext.getUniverse();
            File universeDir = new File(this.getLibraryDirectory(), universe);
            File dir4version = key.getSubDirectory(universeDir);
            repoContext.fetchMeta(key, dir4version);
            ElementNature nature = repoContext.determineNature(key, dir4version);
            if (key.type == null) {
                ElementType type = EBuildUtil.determineElementType(dir4version);
                key = key.withType(type);
            }
            r = this.newPart(EBuildMode.library, nature, dir4version, key);
            r.setRepository(repoContext.repo);
            this.libraryParts.put(key, r);
        }
        return r;
    }

    public AbstractRepositoryProvider expectProviderPlugin(String repoType) throws EBuildException {
        AbstractRepositoryProvider r = this.providers.get(repoType);
        if (r == null) {
            r = InstallRepoProvider.install(this, repoType);
            this.providers.put(repoType, r);
        }
        return r;
    }

    public String inferRepositoryType(File dir) {
        if (new File(dir, ".svn").isDirectory()) {
            return "svn";
        }
        return null;
    }

    public AbstractWorkingCopy inferWorkingCopy(File dir) throws EBuildException {
        try {
            if (!this.inferWorkingCopies) {
                return null;
            }
            String type = this.inferRepositoryType(dir);
            if (type == null) {
                return null;
            }
            AbstractRepositoryProvider prov = this.expectProviderPlugin("svn");
            return prov.getWorkingCopy(dir);
        }
        catch (RepositoryPluginException e) {
            throw EBuildException.wrapPluginException("Could not infer source control for dir '" + this.formatAsDisplayPath(dir) + "'", e);
        }
    }

    public IRepository getRepository(String repositoryType, String repositoryUrl) throws EBuildException {
        AbstractRepositoryProvider prov = this.expectProviderPlugin(repositoryType);
        try {
            return prov.getRepository(repositoryUrl);
        }
        catch (RepositoryPluginException e) {
            throw EBuildException.wrapPluginException("Could not creat repository '" + repositoryUrl + "'", e);
        }
    }

    public IRepository getRepository(Xml.Repository repoXml) throws EBuildException {
        return this.getRepository(repoXml.type, repoXml.url);
    }

    public static class Options
    implements Cloneable {
        public boolean noSkipping = false;
        public boolean verbose = false;
        public boolean debug = false;
        public File home = new File("../_ebuild");
        public List<File> workspaces = CollectionUtil.newList(new File(".."));
        public List<String> overrideRepositories = CollectionUtil.EMPTY_LIST;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }
}

