/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.core.CPart;
import ebuild.core.EBuildContext;
import ebuild.core.EclipseProject;
import ebuild.core.ElementNature;
import ebuild.core.ElementResolver;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.Xml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element<D extends Xml.EBuildElement> {
    private final File f;
    public final ElementResolver resolver;
    public final EBuildMode mode;
    public final EBuildContext context;
    private IRepository repository = null;
    private AbstractWorkingCopy workingCopy = null;
    public final EKey key;
    private final File metaDir;
    private D declaration;
    private final File buildDir;
    private final File releaseDir;
    private final File projectDir;
    public final ElementNature nature;
    private ProjectHelper projectHelper;
    private EclipseProject eclipseProject;
    private Map<ConfSet, CPart> configurations = new HashMap<ConfSet, CPart>();
    private Long lastModified = null;

    public Element(EBuildMode mode, File directory, ElementResolver resolver, EKey key, ElementNature nature) throws EBuildException {
        assert (key.universe != null);
        this.f = FileUtil.canonicalFile(directory);
        this.mode = mode;
        this.resolver = resolver;
        this.context = new EBuildContext(this, EBuildContext.Type.main);
        this.key = key;
        this.metaDir = FileUtil.canonicalFile(this.getFile("meta"));
        this.projectDir = FileUtil.canonicalFile(this.getFile(mode == EBuildMode.library ? "project" : "."));
        this.buildDir = FileUtil.canonicalFile(this.getFile("build"));
        this.releaseDir = FileUtil.canonicalFile(this.getFile("release"));
        this.nature = nature;
        if (this.isSource()) {
            this.projectHelper = this.newProjectHelper();
        }
    }

    public abstract CPart newCPart(ConfSet var1, ConfSet var2);

    public abstract ProjectHelper newProjectHelper() throws EBuildException;

    public void initDeclaration(D declaration) throws EBuildException {
        this.declaration = declaration;
    }

    public File javaFile() {
        return this.f;
    }

    public File getFile(String name) {
        return new File(this.f, name);
    }

    public boolean isWorkspace() {
        return this.mode == EBuildMode.workspace;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
        this.context.addRepository("local", repository, this.key.org);
        if (this.isSource()) {
            this.getProjectHelper().context.addRepository("local", repository, this.key.org);
        }
    }

    public AbstractWorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(AbstractWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    public boolean hasMetaDirectory() {
        return this.metaDir.exists();
    }

    public File getMetaDirectory() {
        return this.metaDir;
    }

    public abstract ElementType getType();

    public D getDeclaration() {
        return this.declaration;
    }

    public String getName() {
        return this.key.fullname();
    }

    public Version getVersion() {
        return this.key.version;
    }

    public String toString() {
        return this.mode.code + " " + this.key;
    }

    public long lastModificationOfSource() {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            File[] fs = this.getProjectDirectory().listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (!f.getName().startsWith("src")) continue;
                    r = Math.max(r, FileUtil.deepLastModified(f));
                }
                r = Math.max(r, FileUtil.deepLastModified(this.getMetaDirectory()));
            } else {
                r = Long.MAX_VALUE;
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }

    public boolean hasBuildDirectory() {
        return this.buildDir.exists();
    }

    public File getBuildDirectory() {
        return this.buildDir;
    }

    public boolean hasReleaseDirectory() {
        return this.releaseDir.exists();
    }

    public File getReleaseDirectory() {
        return this.releaseDir;
    }

    public boolean hasProjectDirectory() {
        return this.projectDir.exists();
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public boolean buildIsClean() {
        return !this.hasBuildDirectory() && !this.hasReleaseDirectory();
    }

    public void buildClean() {
        FileUtil.deleteDir(this.getBuildDirectory());
        FileUtil.deleteDir(this.getReleaseDirectory());
    }

    public ProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public ProjectHelper expectProjectHelper() throws EBuildException {
        ProjectHelper r = this.getProjectHelper();
        if (r == null) {
            throw EBuildException.newProblem("Build context unavailable: " + this.key);
        }
        return r;
    }

    private ConfSet actualConfiguration(ConfSet configurationSelected) throws EBuildException {
        Map<String, ConfSet> aliases = this.getAliases();
        if (configurationSelected.isEmpty()) {
            ConfSet actual = aliases.get("[default]");
            if (actual != null) {
                return actual;
            }
            return configurationSelected;
        }
        ConfSet configuration = configurationSelected;
        if (aliases.size() > 0) {
            ConfSet.Builder b = new ConfSet.Builder();
            for (String c : configurationSelected.asCollection()) {
                if (aliases.containsKey(c)) {
                    b.addAll(aliases.get(c));
                    continue;
                }
                b.add(c);
            }
            configuration = b.build();
        }
        return configuration;
    }

    public Set<String> listCheckedIn() {
        File dir = this.getFile("checkedin");
        if (!dir.isDirectory()) {
            return CollectionUtil.EMPTY_SET;
        }
        String[] fs = dir.list();
        HashSet<String> r = new HashSet<String>(fs.length);
        for (String f : fs) {
            r.add(f);
        }
        return r;
    }

    public CPart getCPart(ConfSet configurationSelected) throws EBuildException {
        ConfSet configuration = this.actualConfiguration(configurationSelected);
        CPart r = this.configurations.get(configuration);
        if (r == null) {
            r = this.newCPart(configuration, configurationSelected);
            this.configurations.put(configuration, r);
        }
        return r;
    }

    public EclipseProject createEclipseProject(CPart cpart) {
        if (this.eclipseProject == null) {
            this.eclipseProject = cpart.newEclipseProject();
            try {
                this.eclipseProject.storeConfiguration();
            }
            catch (IOException e) {
                throw new Error("Unable to store configuration", e);
            }
            return this.eclipseProject;
        }
        if (cpart.getConfiguration().equals(this.eclipseProject.getConfiguration())) {
            return this.eclipseProject;
        }
        throw new Error("Attempted to have eclipse project for '" + this.key + "'with 2 different configurations: " + "\n" + cpart.getConfiguration() + "\n" + this.eclipseProject.getConfiguration());
    }

    public EclipseProject expectEclipseProject() {
        if (this.eclipseProject == null) {
            throw new RuntimeException("No eclipse project for " + this.key);
        }
        return this.eclipseProject;
    }

    Map<String, ConfSet> getAliases() throws EBuildException {
        HashMap<String, ConfSet> r = new HashMap<String, ConfSet>();
        for (Xml.Configuration c : ((Xml.EBuildElement)this.getDeclaration()).configurations) {
            if (c.aliases == null) continue;
            ConfSet confs = EBuildUtil.parseConfSet(c.aliases);
            r.put(c.name, confs);
        }
        return r;
    }

    public Collection<String> getConfsNotUsedInName() {
        ArrayList<String> r = new ArrayList<String>();
        for (Xml.Configuration c : ((Xml.EBuildElement)this.getDeclaration()).configurations) {
            if (c.useInName != Boolean.FALSE) continue;
            r.add(c.name);
        }
        return r;
    }

    public boolean isSource() {
        return this.nature.isSource();
    }

    public void addIgnores(List<String> patterns) {
        if (!this.isWorkspace()) {
            throw new Error("Tryed to add a ignores to a non-workspace part: " + this);
        }
        AbstractWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            return;
        }
        wc.addIgnores(patterns);
    }

    public void addIgnores(String ... patterns) {
        this.addIgnores(CollectionUtil.newList(patterns));
    }

    public Date getLastCommitDate() {
        if (this.isWorkspace()) {
            return new Date();
        }
        Date r = FileUtil.readTimestampFile(this.getMetaDirectory());
        if (r == null) {
            r = new Date(this.getProjectDirectory().lastModified());
        }
        return r;
    }
}

