/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.CPart;
import ebuild.core.Module;
import ebuild.core.ModuleBuildProject;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleEclipseProject;
import ebuild.core.ModuleRelease;
import ebuild.core.Release;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.BuilderChain;
import ebuild.core.impl.BuilderInstance;
import ebuild.core.impl.BuilderPrototype;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.xml.Xml;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCPart
extends CPart<Module> {
    private final Module module;
    private BuilderChain buildChain;

    public ModuleCPart(Module module, ConfSet configuration, ConfSet configurationSelected) {
        super(module, configuration, configurationSelected);
        this.module = module;
    }

    @Override
    public ModuleBuildProject newBuildProject() {
        return new ModuleBuildProject((CPart<Module>)this);
    }

    @Override
    public ModuleEclipseProject newEclipseProject() {
        return new ModuleEclipseProject((CPart<Module>)this);
    }

    @Override
    public Release newRelease() {
        return new ModuleRelease(this.getReleaseDirectory(), this);
    }

    @Override
    public Release<Module> registerRelease() throws EBuildException {
        if (this.part instanceof Module) {
            Module m = (Module)this.part;
            try {
                m.registerRelease(this);
            }
            catch (Exception e) {
                System.err.println("[WARNING] Unable to register plugin: " + e.getMessage());
            }
        }
        return super.registerRelease();
    }

    public BuilderChain getBuildChain() {
        return this.buildChain;
    }

    @Override
    public ModuleCDependencies getDependencies() {
        return (ModuleCDependencies)super.getDependencies();
    }

    public BuilderChain configureAndParameterizeBuilderChain() throws EBuildException {
        Iterable builderXmls = ((Module)this.part).getProjectHelper().getBuildDependencies(this.getConfiguration());
        ArrayList<BuilderInstance> builders = new ArrayList<BuilderInstance>(builderXmls.size());
        for (Xml.Builder bXml : builderXmls) {
            EKey bkey = ((Module)this.part).getProjectHelper().context.newModuleKey(bXml);
            Module builder = (Module)this.getDependencies().builders.get(bkey);
            EKey key_resolved = builder.key;
            BuilderPrototype b = this.module.ebuild.expectBuilder(key_resolved);
            builders.add(new BuilderInstance(b, bXml));
        }
        this.buildChain = new BuilderChain(builders);
        return this.buildChain;
    }
}

