/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.Scope;
import ebuild.api.plugin.IPropertyMap;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EclipseProject;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleCPart;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.impl.BuilderChain;
import ebuild.core.impl.BuilderInstance;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleEclipseProject
extends EclipseProject<Module>
implements IModuleWorkspaceProject,
IModuleBuildProject {
    private Module module;
    private final ModuleProjectHelper helper;
    private List<String> natures = new ArrayList<String>(2);
    private List<String> buildCommands = new ArrayList<String>(2);
    private static final Scope[] CALL_ORDER = new Scope[]{Scope.MAIN, Scope.POKE, Scope.TEST};

    public ModuleEclipseProject(CPart<Module> cpart) {
        super((CPart)cpart);
        this.module = (Module)this.getPart();
        this.helper = this.module.getProjectHelper();
    }

    @Override
    public ModuleCPart getCPart() {
        return (ModuleCPart)super.getCPart();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    @Override
    public String getSrcPath(boolean gen, Scope scope, String type) {
        return this.helper.getSrcFolder(gen, scope, type);
    }

    @Override
    public String getArtifactPath(String kind, Scope scope, String type) {
        return this.helper.getSrcFolder(kind, scope, type);
    }

    @Override
    public boolean isWorkspace() {
        return ((Module)this.getPart()).isWorkspace();
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s) {
        return this.getCheckedInArtifacts(s, null);
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return this.helper.getCheckedInArtifacts(this.cpart, s, type);
    }

    @Override
    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    @Override
    public Collection<IModuleRelease> getDependencies(Scope scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IModuleRelease getModuleRelease() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersionString() {
        return ((Module)this.getPart()).key.version + "";
    }

    @Override
    public void addIgnores(String ... patterns) {
        this.module.addIgnores(patterns);
    }

    @Override
    public void addNature(String nature) {
        this.natures.add(nature);
    }

    @Override
    public void addBuildCommand(String builder) {
        this.buildCommands.add(builder);
    }

    @Override
    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies() {
        return this.getWorkspaceDependencies(Scope.TEST);
    }

    @Override
    public Collection<IModuleRelease> getLibraryDependencies() {
        return this.getReleasedDependencies(Scope.TEST);
    }

    @Override
    public Collection<IModuleRelease> getReleasedDependencies(Scope scope) {
        ModuleCDependencies deps = (ModuleCDependencies)this.cpart.getDependencies();
        HashSet<IModuleRelease> r = new HashSet<IModuleRelease>(deps.parts.size());
        for (ModuleCDependencies.PartDep pd : deps.parts.values()) {
            if (pd.cpart.eclipse != null || !scope.includes(pd.scope)) continue;
            r.add((IModuleRelease)((Object)pd.cpart.release));
        }
        return r;
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        ModuleCDependencies deps = (ModuleCDependencies)this.cpart.getDependencies();
        HashSet<IModuleWorkspaceProject> r = new HashSet<IModuleWorkspaceProject>(deps.parts.size());
        for (ModuleCDependencies.PartDep pd : deps.parts.values()) {
            if (pd.cpart.eclipse == null || !scope.includes(pd.scope)) continue;
            r.add((IModuleWorkspaceProject)((Object)pd.cpart.eclipse));
        }
        return r;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        long projectModified = this.getSourceFile(".project").lastModified();
        final EBuild ebuild = this.module.ebuild;
        ModuleProjectHelper helper = this.module.getProjectHelper();
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            final IPropertyMap props = helper.configureProperties(this, b);
            if (b.hasEclipseNature()) {
                b.generateEclipseProjectSettings(new IGenConfArgument(){

                    public IModuleWorkspaceProject getModuleWorkspaceProject() {
                        return ModuleEclipseProject.this;
                    }

                    public IEBuild getEBuild() {
                        return ebuild;
                    }

                    public IPropertyMap getPropertyMap() {
                        return props;
                    }
                });
                continue;
            }
            for (Scope s : CALL_ORDER) {
                ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, b.getBuilder(), s, props){

                    public boolean isBuild() {
                        return false;
                    }

                    public boolean isFirstCall() {
                        return this.scope == CALL_ORDER[0];
                    }

                    public CPart getCPart() {
                        return ModuleEclipseProject.this.cpart;
                    }

                    public File getExportDirectory(String artifactType) {
                        throw new Error("!");
                    }

                    protected File getGenDirectory(String artifactType) {
                        return new File(ModuleEclipseProject.this.module.getProjectDirectory(), ModuleEclipseProject.this.getSrcPath(true, this.getScope(), artifactType));
                    }

                    public File getIntermediateDir(String uniquePath) {
                        throw new UnsupportedOperationException();
                    }

                    public IModuleBuildProject getModuleBuildProject() {
                        return ModuleEclipseProject.this;
                    }

                    public File getOutputDir(String artifactType) {
                        return this.getGenDirectory(artifactType);
                    }
                };
                b.build(arg);
            }
        }
        if (projectModified == this.getSourceFile(".project").lastModified()) {
            this.generateDotProject();
        }
    }

    @Override
    public void unsetup() throws Exception {
        super.unsetup();
        FileUtil.deleteDir(this.module.getFile("gen"));
        this.module.getFile(".classpath").delete();
    }

    private void generateDotProject() throws IOException {
        StringTemplate template = ModuleEclipseProject.getTemplate("project");
        template.setAttribute("name", this.module.getName());
        template.setAttribute("natures", this.natures);
        template.setAttribute("buildCommands", this.buildCommands);
        this.writeFile(".project", template.toString());
    }

    private static StringTemplateGroup getTemplateGroup(String name) throws IOException {
        URL url = ModuleEclipseProject.class.getResource(name);
        InputStream is = url.openStream();
        return new StringTemplateGroup((Reader)new InputStreamReader(is), DefaultTemplateLexer.class);
    }

    private static StringTemplate getTemplate(String name) throws IOException {
        return ModuleEclipseProject.getTemplateGroup(name + ".stg").getInstanceOf(name);
    }

    private void writeFile(String path, String contents) throws IOException {
        IOUtil.stringToFile(contents, this.getSourceFile(path));
    }
}

