/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class SmartReader {
    PushbackReader reader = null;
    int lastread = -1;
    int col = 0;
    int line = 0;
    StringBuilder accumulator = null;

    public SmartReader(Reader r) {
        this.reader = new PushbackReader(r);
    }

    public int col() {
        return this.col;
    }

    public int line() {
        return this.line;
    }

    public void unread() throws IOException {
        this.unread(this.lastread);
    }

    public void unread(int c) throws IOException {
        if (c == -1) {
            return;
        }
        this.reader.unread(c);
        this.col = c == 10 ? -1 : --this.col;
        if (this.accumulator != null) {
            this.accumulator.setLength(this.accumulator.length() - 1);
        }
    }

    public boolean match(char c) throws IOException {
        if (this.peek() == c) {
            this.reader.read();
            return true;
        }
        return false;
    }

    public int peek() throws IOException {
        int peeked = this.reader.read();
        if (peeked != -1) {
            this.reader.unread((char)peeked);
        }
        return peeked;
    }

    public int read() throws IOException {
        this.lastread = this.reader.read();
        if (this.lastread == -1) {
            return -1;
        }
        if (this.accumulator != null) {
            this.accumulator.append((char)this.lastread);
        }
        if (this.lastread != 10 && this.lastread != 13) {
            ++this.col;
        }
        if (this.lastread == 10) {
            if (this.col != -1) {
                ++this.line;
            }
            this.col = 0;
        }
        return this.lastread;
    }

    public void startString() {
        this.accumulator = new StringBuilder();
        this.accumulator.append((char)this.lastread);
    }

    public String getString() throws IOException {
        String ret = this.accumulator.toString().intern();
        this.accumulator = null;
        return ret;
    }
}

