/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleRelease;
import ebuild.core.CDependencies;
import ebuild.core.CPart;
import ebuild.core.Component;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleRelease;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ComponentCDependencies
extends CDependencies {
    public final Map<String, ComponentDep> components = new HashMap<String, ComponentDep>();
    public final Map<String, ModuleSelectionDep> moduleSelections = new HashMap<String, ModuleSelectionDep>();

    public void addComponent(ComponentDep dep) {
        this.components.put(dep.key, dep);
    }

    public void addModuleSelection(ModuleSelectionDep dep) {
        this.moduleSelections.put(dep.key, dep);
    }

    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (Module m : this.builders.values()) {
            try {
                r = Math.max(r, m.getCPart(ConfSet.EMPTY).lastModification());
            }
            catch (EBuildException e) {
                throw new Error(e);
            }
        }
        for (ComponentDep cd : this.components.values()) {
            r = Math.max(r, cd.cpart.lastModification());
        }
        for (ModuleSelectionDep msd : this.moduleSelections.values()) {
            for (CPart cp : msd.modules) {
                r = Math.max(r, cp.lastModification());
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentDep {
        final String key;
        final CPart<Component> cpart;

        public ComponentDep(String key, CPart<Component> cpart) {
            this.key = key;
            this.cpart = cpart;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleSelectionDep {
        final String key;
        final Collection<CPart> modules;
        final Set<EKey> excludeDependencies;

        public ModuleSelectionDep(String key, Collection<CPart> modules, Set<EKey> excludeDependencies) {
            this.key = key;
            this.modules = modules;
            this.excludeDependencies = excludeDependencies;
        }

        public void buildModuleCollection(CollectionUtil.Filter<ModuleCDependencies.AbstractDep> inclusionFilter, Collection<IModuleRelease> modules) {
            for (CPart cpart : this.modules) {
                modules.add((ModuleRelease)cpart.release);
                if (this.excludeDependencies.contains(((Element)cpart.part).key)) continue;
                ModuleCDependencies mcdeps = (ModuleCDependencies)cpart.getDependencies();
                mcdeps.buildModuleCollection(inclusionFilter, modules, mcdeps.getParts().values());
            }
        }
    }
}

