/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.core.EBuildContext;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import java.util.Map;

public class RepositoryRef {
    private static final String WORKSPACE = "workspace";
    public final EBuildContext context;
    public final String name;
    private final IRepository repository;
    private String defaultOrg;

    RepositoryRef(EBuildContext context, String name, IRepository repository, String defaultOrg) {
        this(context, name, repository);
        this.defaultOrg = defaultOrg;
    }

    RepositoryRef(String name, IRepository repository) {
        this(null, name, repository);
    }

    public RepositoryRef(EBuildContext context, String name, IRepository repository) {
        this.context = context;
        this.name = name;
        this.repository = repository;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public String getDefaultOrg() throws EBuildException {
        if (this.defaultOrg == null) {
            throw EBuildException.newProblem("\"org\" must be specified for repository: " + this.name);
        }
        return this.defaultOrg;
    }

    public void setDefaultOrg(String defaultOrg) {
        this.defaultOrg = defaultOrg;
    }

    public String toString() {
        return this.context + "--" + this.name;
    }

    public String getUniverse() {
        if (this.repository == null) {
            return "ebuild";
        }
        return this.repository.getUniverse();
    }

    static class Source
    extends RepositoryRef {
        private String fixedRevision;

        public Source(EBuildContext context, String name, AbstractSourceRepository repository, String defaultOrg) {
            super(context, name, repository, defaultOrg);
        }

        public AbstractSourceRepository getRepository() {
            return (AbstractSourceRepository)super.getRepository();
        }

        public String expectFixedRevision() throws EBuildException {
            if (this.fixedRevision == null) {
                String repoUrl = this.getRepository().getUri();
                Map<String, String> upstreamRevisions = this.context.getUpstreamRevisions();
                this.fixedRevision = upstreamRevisions.get(repoUrl);
            }
            if (this.fixedRevision == null) {
                throw EBuildException.newProblem("Upstream dependency not fixed to a revision: " + this + "-" + this.name);
            }
            if (this.fixedRevision.equals(RepositoryRef.WORKSPACE)) {
                throw EBuildException.newProblem("Upstream dependency fixed to workspace: " + this + "-" + this.name);
            }
            return this.fixedRevision;
        }

        public String getUpdatedFixedRevision(EBuildContext from, EKey dkey) throws EBuildException {
            if (this.context.element.isWorkspace()) {
                if (this.fixedRevision == null) {
                    String latest = EBuildUtil.getHeadRevision(this.getRepository());
                    this.writeFixedRevision(from, dkey, latest);
                } else if (this.fixedRevision.equals(RepositoryRef.WORKSPACE)) {
                    return EBuildUtil.getHeadRevision(this.getRepository());
                }
                return this.fixedRevision;
            }
            return this.expectFixedRevision();
        }

        public void setFixedRevisionToWorkspace(EBuildContext from, EKey key) throws EBuildException {
            if (RepositoryRef.WORKSPACE.equals(this.fixedRevision)) {
                return;
            }
            this.writeFixedRevision(from, key, RepositoryRef.WORKSPACE);
        }

        private void writeFixedRevision(EBuildContext from, EKey dkey, String latest) throws EBuildException {
            String repoUrl = this.getRepository().getUri();
            Map<String, String> upstreamRevisions = this.context.getUpstreamRevisions();
            String latestPreviously = upstreamRevisions.get(repoUrl);
            if (!latest.equals(latestPreviously)) {
                if (!this.context.element.isWorkspace()) {
                    throw EBuildException.newProblem("Cannot update revision for '" + dkey + "' " + latestPreviously + "->" + latest);
                }
                upstreamRevisions.put(repoUrl, latest);
                this.context.updateUpstreamRevisions(upstreamRevisions);
            }
            this.fixedRevision = latest;
        }
    }
}

