/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;

public class EKey
implements IElementKey {
    public final ElementType type;
    public final String universe;
    public final String org;
    public final String name;
    public final Version version;

    public static EKey newWorkingKey(ElementType type, File projectDir) throws EBuildException {
        if (type == null) {
            type = EBuildUtil.determineElementType(projectDir);
        }
        return EKey.newVersionedFromFullname(type, projectDir.getName(), "working");
    }

    public static EKey newVersionedFromFullname(ElementType type, String org_name, String version) throws EBuildException {
        String[] ss = org_name.split("-");
        if (ss.length != 2) {
            throw EBuildException.newProblem("Expected form of ebuild project directories is [org]-[name], got: " + org_name);
        }
        return EKey.newVersioned(type, "ebuild", ss[0], ss[1], version);
    }

    public static EKey newRevision(ElementType type, String universe, String org, String name, String branch, String revision) throws EBuildException {
        return new EKey(type, universe, org, name, Version.newRevision(branch, revision));
    }

    public static EKey newVersioned(ElementType type, String universe, String org, String name, String version) throws EBuildException {
        return new EKey(type, universe, org, name, Version.newTag(version));
    }

    public static EKey newUnversioned(String universe, String org, String name) {
        return new EKey(null, universe, org, name, null);
    }

    public EKey(ElementType type, String universe, String org, String name, Version version) {
        this.type = type;
        this.universe = universe;
        this.org = org;
        this.name = name;
        this.version = version;
    }

    public EKey withOrg(String newOrg) {
        return new EKey(this.type, this.universe, newOrg, this.name, this.version);
    }

    public EKey withVersion(Version version) {
        return new EKey(this.type, this.universe, this.org, this.name, version);
    }

    public EKey withTag(String tag) {
        return this.withVersion(Version.newTag(tag));
    }

    public EKey withRevision(String revision) {
        return this.withVersion(this.version.withRevision(revision));
    }

    public EKey withType(ElementType type) {
        return new EKey(type, this.universe, this.org, this.name, this.version);
    }

    public String getDefaultWorkspaceName() {
        return this.org + "-" + this.name;
    }

    public boolean isDefaultUniverse() {
        return this.universe == null;
    }

    public String fullname() {
        return this.org + "-" + this.name;
    }

    public String fullnameAndVersion() {
        String r = this.fullname();
        if (this.version != null) {
            r = r + "-" + this.version;
        }
        return r;
    }

    public String fullnameAndVersionAndUniverse() {
        String r = this.fullnameAndVersion();
        if (this.universe != null) {
            r = this.universe + "/" + r;
        }
        return r;
    }

    public String toString() {
        return StringUtil.rpad(9, (Object)((Object)this.type) + "") + " " + this.fullnameAndVersionAndUniverse();
    }

    public File getSubDirectory(File libraryDir) {
        return new File(libraryDir, this.asLibraryPath());
    }

    public String asLibraryPath() {
        if (this.version.isTag()) {
            return this.fullname() + "/" + this.version.getTag() + "/";
        }
        return this.fullname() + "/" + this.version.getBranch() + "/" + this.version.getRevision() + "/";
    }

    public int hashCode() {
        return ObjectUtil.hashOf((Object)this.type) + ObjectUtil.hashOf(this.universe) + ObjectUtil.hashOf(this.org) + ObjectUtil.hashOf(this.name) + ObjectUtil.hashOf(this.version);
    }

    public boolean equals(Object obj) {
        EKey b = (EKey)obj;
        return ObjectUtil.areEqual((Object)this.type, (Object)b.type) && ObjectUtil.areEqual(this.universe, b.universe) && ObjectUtil.areEqual(this.org, b.org) && ObjectUtil.areEqual(this.name, b.name) && ObjectUtil.areEqual(this.version, b.version);
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public ElementType getType() {
        return null;
    }

    public IVersion getVersion() {
        return this.version;
    }
}

