/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.http;

import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.util.FileUtil;
import ebuild.util.HttpUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRepository
extends AbstractReleaseRepository {
    private final String universe;
    private final String baseUrl;

    public HttpRepository(String universe, String baseUrl) {
        this.universe = universe;
        this.baseUrl = baseUrl;
    }

    @Override
    public String getUniverse() {
        return this.universe;
    }

    @Override
    public String getUri() {
        return this.baseUrl;
    }

    @Override
    public String getLastChangeRevision(IElementKey key) throws RepositoryPluginException {
        String path = key.asLibraryPath();
        String url = this.baseUrl + path;
        boolean isDir = this.doIsDir(url);
        if (isDir) {
            return key.getVersion().getRevision();
        }
        try {
            String redirect = HttpUtil.getString(url);
            return redirect;
        }
        catch (IOException e) {
            throw new RepositoryPluginException("Problem downloading file : " + url + "\n" + e.getMessage());
        }
    }

    @Override
    public void fetchModuleRelease(File artifactDir, IElementKey key, IConfiguration conf) throws RepositoryPluginException {
        String path = key.asLibraryPath() + "release/" + conf.asDirectoryName() + "/main/";
        String url = this.baseUrl + path + "/";
        this.download(url, artifactDir);
    }

    @Override
    public void fetchComponentRelease(File releaseDir, IElementKey key, String filename) throws RepositoryPluginException {
        File file = new File(releaseDir, filename);
        String path = key.asLibraryPath() + "release/" + filename;
        String url = this.baseUrl + path;
        this.download(url, file);
    }

    @Override
    public void fetchMeta(File metaDir, IElementKey key) throws RepositoryPluginException {
        String path = key.asLibraryPath() + "meta/";
        String url = this.baseUrl + path + "/";
        this.download(url, metaDir);
    }

    private void download(String url, File file) throws RepositoryPluginException {
        if (url.endsWith("/")) {
            file.mkdirs();
            List<String> files = this.doList(url);
            for (String f : files) {
                this.download(url + f, new File(file, f));
            }
        } else {
            try {
                HttpUtil.get(url, file);
            }
            catch (IOException e) {
                throw new RepositoryPluginException("Problem downloading file : " + url + "\n" + e.getMessage());
            }
        }
    }

    private List<String> doList(String url) throws RepositoryPluginException {
        return (List)this.doCommand(url, "list");
    }

    private boolean doIsDir(String url) throws RepositoryPluginException {
        return (Boolean)this.doCommand(url, "isDir");
    }

    private Object doCommand(String url, String command) throws RepositoryPluginException {
        url = url + "?command=" + command;
        try {
            return HttpUtil.getJson(url);
        }
        catch (IOException e) {
            throw new RepositoryPluginException("Problem requesting command '" + command + "': " + url + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw new RepositoryPluginException("Invalid json from: " + url);
        }
    }

    public FileFilter getFileFilter() {
        return FileUtil.FILEFILTER_ALL;
    }
}

