/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.core.CPart;
import ebuild.core.ComponentCPart;
import ebuild.core.ComponentProjectHelper;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.core.util.NameTemplate;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Element<ComponentXml.EbuildComponent> {
    public final EBuild ebuild;
    private NameTemplate templateOutput;
    private NameTemplate templateSource;

    public Component(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
        this.ebuild = ebuild;
    }

    @Override
    public void initDeclaration(ComponentXml.EbuildComponent declaration) throws EBuildException {
        super.initDeclaration(declaration);
        this.templateOutput = this.nameTemplateOfOutput();
        this.templateSource = this.nameTemplateOfSource();
    }

    @Override
    public CPart newCPart(ConfSet conf, ConfSet confSelected) {
        return new ComponentCPart(this, conf, confSelected);
    }

    @Override
    public ComponentProjectHelper newProjectHelper() throws EBuildException {
        return new ComponentProjectHelper(this);
    }

    @Override
    public ComponentProjectHelper getProjectHelper() {
        return (ComponentProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.component;
    }

    public Map<String, ModuleSelectionIncludes> getModuleSelectionXml(final ConfSet conf) throws EBuildException {
        final HashMap<String, ModuleSelectionIncludes> r = new HashMap<String, ModuleSelectionIncludes>();
        ComponentProjectHelper componentProjectHelper = this.getProjectHelper();
        componentProjectHelper.getClass();
        new ComponentProjectHelper.AssemblyVisitor(componentProjectHelper, conf){
            {
                ComponentProjectHelper componentProjectHelper = x0;
                componentProjectHelper.getClass();
                super(componentProjectHelper, x1);
            }

            public Object visitModuleSelection(String path, ComponentXml.ModuleSelection moduleSelection) {
                String groupMapping = moduleSelection.groupMapping;
                if (groupMapping == null) {
                    groupMapping = "";
                }
                List<ComponentXml.Include> l = moduleSelection.includes;
                ComponentXml.OurModule ours = moduleSelection.ourModule;
                if (ours != null) {
                    ComponentXml.Include inc = new ComponentXml.Include();
                    inc.source = "local";
                    inc.org = Component.this.key.org;
                    inc.name = Component.this.key.name;
                    inc.confs = conf.toString();
                    inc.revision = Component.this.key.version.getRevision();
                    inc.branch = Component.this.key.version.getBranch();
                    inc.version = Component.this.key.version.getTag();
                    inc.dependencies = ours.dependencies;
                    ArrayList<ComponentXml.Include> l2 = new ArrayList<ComponentXml.Include>(l.size() + 1);
                    l2.addAll(l);
                    l2.add(inc);
                    l = l2;
                }
                ModuleSelectionIncludes msi = new ModuleSelectionIncludes(moduleSelection.groupMapping, l);
                r.put(path, msi);
                return null;
            }
        }.go();
        return r;
    }

    public Map<String, Xml.SelectAndMap> getSelectedComponentsXml(ConfSet conf) throws EBuildException {
        final HashMap<String, Xml.SelectAndMap> r = new HashMap<String, Xml.SelectAndMap>();
        ComponentProjectHelper componentProjectHelper = this.getProjectHelper();
        componentProjectHelper.getClass();
        new ComponentProjectHelper.AssemblyVisitor(componentProjectHelper, conf){
            {
                ComponentProjectHelper componentProjectHelper = x0;
                componentProjectHelper.getClass();
                super(componentProjectHelper, x1);
            }

            Object visitComponent(String path, Xml.SelectAndMap component) {
                r.put(path, component);
                return null;
            }
        }.go();
        return r;
    }

    public String releaseSourceFileName() {
        String r = this.getNameTemplateOfSource().apply(new NameTemplate.Model(){

            public String getValue(String varname) {
                if ("version".equals(varname)) {
                    return Component.this.key.version + "";
                }
                return null;
            }
        });
        return r;
    }

    public NameTemplate getNameTemplateOfOutput() {
        return this.templateOutput;
    }

    public NameTemplate getNameTemplateOfSource() {
        return this.templateSource;
    }

    private String nameTemplatePattern() throws EBuildException {
        String pattern = ((ComponentXml.EbuildComponent)this.getDeclaration()).release.pattern;
        if (pattern != null) {
            return pattern;
        }
        String name = ((ComponentXml.EbuildComponent)this.getDeclaration()).release.name;
        if (name == null) {
            name = this.getName();
        }
        pattern = name + "{-|confs}{-|version}";
        String suffix = ((ComponentXml.EbuildComponent)this.getDeclaration()).release.suffix;
        if (suffix != null) {
            pattern = pattern + suffix;
        }
        return pattern;
    }

    private NameTemplate nameTemplateOfOutput() throws EBuildException {
        return NameTemplate.parse(this.nameTemplatePattern());
    }

    private NameTemplate nameTemplateOfSource() throws EBuildException {
        NameTemplate r = this.nameTemplateOfOutput();
        r.removeVar("confs");
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleSelectionIncludes {
        final String groupMapping;
        final List<ComponentXml.Include> includes;

        ModuleSelectionIncludes(String groupMapping, List<ComponentXml.Include> includes) {
            this.groupMapping = groupMapping;
            this.includes = includes;
        }
    }
}

