/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Component;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.util.EBuildException;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentProjectHelper
extends ProjectHelper {
    final Component component;
    private ComponentXml.EbuildComponentAssembly buildXml;

    ComponentProjectHelper(Component component) {
        super(component);
        this.component = component;
    }

    @Override
    public ComponentXml.EbuildComponentAssembly getBuildXml() throws EBuildException {
        if (this.buildXml == null) {
            File f = new File(this.component.getMetaDirectory(), "component-assembly.xml");
            this.buildXml = (ComponentXml.EbuildComponentAssembly)EBuildUtil.parseXml(this.component.ebuild, f);
        }
        return this.buildXml;
    }

    public ComponentXml.Assembly getAssemblyXml() throws EBuildException {
        return this.getBuildXml().assembly;
    }

    @Override
    public Iterable<? extends Xml.Select> getBuildDependencies(ConfSet configuration) throws EBuildException {
        final HashSet r = new HashSet(10);
        new AssemblyVisitor(configuration){

            public Object visitAssembler(String path, ComponentXml.Assembler assembler, Map inputs) {
                r.add(assembler);
                return null;
            }
        }.go();
        return r;
    }

    ComponentXml.AssemblyResult expectAssemblyResult(String name) throws EBuildException {
        for (ComponentXml.AssemblyResult a : this.buildXml.assembly.assemblyResults) {
            if (!name.equals(a.name)) continue;
            return a;
        }
        throw EBuildException.newProblem("Bad reference, no <artifact> or <module-selection> id for ref: " + name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AssemblyVisitor<R> {
        final ConfSet configuration;
        Map<String, R> norecurse = new HashMap<String, R>();

        AssemblyVisitor() {
            this(null);
        }

        AssemblyVisitor(ConfSet configuration) {
            this.configuration = configuration;
        }

        R go() throws EBuildException {
            String startRef = ComponentProjectHelper.this.getBuildXml().assembly.release;
            return this.recurseNamed(startRef);
        }

        R visitComponent(String path, Xml.SelectAndMap component) throws EBuildException {
            return null;
        }

        R visitModuleSelection(String path, ComponentXml.ModuleSelection moduleSelection) throws EBuildException {
            return null;
        }

        R visitAssembler(String path, ComponentXml.Assembler assembler, Map<String, R> inputs) throws EBuildException {
            return null;
        }

        R visitGroup(String path, ComponentXml.AssemblyGroup group, List<R> members) throws EBuildException {
            return null;
        }

        R recurseNamed(String name) throws EBuildException {
            if (this.norecurse.containsKey(name)) {
                return this.norecurse.get(name);
            }
            R r = this.recurseGroup(name, ComponentProjectHelper.this.expectAssemblyResult(name));
            this.norecurse.put(name, r);
            return r;
        }

        private String subpath(int size, String path, int i) {
            if (size == 1) {
                return path;
            }
            return path + "_" + i;
        }

        R recurseGroup(String path, ComponentXml.AssemblyGroup group) throws EBuildException {
            return this.visitGroup(path, group, this.recurseGroupMembers(path, group));
        }

        List<R> recurseGroupMembers(String path, ComponentXml.AssemblyGroup group) throws EBuildException {
            String path2;
            int size = group.count();
            ArrayList<R> r = new ArrayList<R>(size);
            int i = 0;
            if (group.ref != null) {
                ++i;
                r.add(this.recurseNamed(group.ref));
            }
            for (ComponentXml.Ref ref : group.refs) {
                ++i;
                r.add(this.recurseNamed(ref.name));
            }
            for (ComponentXml.Assembler ass : group.assemblers) {
                path2 = this.subpath(size, path, i++);
                r.add(this.visitAssembler(path2, ass, this.recurseInputs(path2, ass.inputList)));
            }
            for (Xml.SelectAndMap c : group.components) {
                if (EBuildUtil.evaluateConfExpr(c.confs, this.configuration)) {
                    r.add(this.visitComponent(this.subpath(size, path, i), c));
                }
                ++i;
            }
            for (ComponentXml.ModuleSelection ms : group.moduleSelections) {
                r.add(this.visitModuleSelection(this.subpath(size, path, i++), ms));
            }
            for (ComponentXml.If if_ : group.ifs) {
                path2 = this.subpath(size, path, i++);
                r.add(this.recurseIf(path2, if_));
            }
            return r;
        }

        Map<String, R> recurseInputs(String path, List<ComponentXml.Input> inputs) throws EBuildException {
            LinkedHashMap<String, R> r = new LinkedHashMap<String, R>(inputs.size());
            for (ComponentXml.Input i : inputs) {
                String name;
                String path2 = i.appendToPath(path);
                R a = this.recurseGroup(path2, i);
                String string = name = i.name == null ? "anonymous" : i.name;
                if (r.containsKey(name)) {
                    throw EBuildException.newProblem("Multiple inputs must have distinct names: " + name);
                }
                r.put(i.name, a);
            }
            return r;
        }

        R recurseIf(String path, ComponentXml.If if_) throws EBuildException {
            if (EBuildUtil.evaluateConfExpr(if_.confs, this.configuration)) {
                return this.recurseGroup(path, if_.then);
            }
            return this.recurseGroup(path, if_.else_);
        }
    }
}

