/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.core.EBuild;
import ebuild.core.EBuildRunner;
import ebuild.core.Module;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.CollectionUtil;
import java.util.Map;

public class InstallRepoProvider
extends EBuildRunner {
    public static final AbstractRepositoryProvider HTTP_PROVIDER = new HttpRepositoryProvider();
    private static Map<String, String> type2plugin = CollectionUtil.newMap("svn", "repo.svn", "maven", "repo.maven", "ivy", "repo.ivy", "http", "repo.http");
    private static Map<String, Version> name2version = CollectionUtil.newMap("repo.svn", Version.newRevision("trunk", "134"), "repo.maven", Version.newRevision("trunk", "134"), "repo.ivy", Version.newRevision("trunk", "134"));
    final Module module;

    public static AbstractRepositoryProvider install(EBuild ebuild0, String repoType) throws EBuildException {
        EKey wkey;
        ebuild0.logger.log("*using repository provider '" + repoType + "'");
        if ("http".equals(repoType)) {
            return HTTP_PROVIDER;
        }
        String name = type2plugin.get(repoType);
        if (name == null) {
            throw EBuildException.newProblem("Unknown repository type: " + repoType);
        }
        Version v = name2version.get(name);
        EKey key = new EKey(ElementType.module, "ebuild", "ebuild", name, v);
        EBuild.Options options = (EBuild.Options)ebuild0.options.clone();
        options.noSkipping = false;
        options.verbose = false;
        EBuild ebuild = new EBuild(options, ebuild0.logger_verbose.newSubLogger("Installing " + key.fullname()), false);
        Module module = (Module)ebuild.resolveWorkspaceElement(wkey = key.withRevision("working"));
        if (module == null) {
            module = (Module)ebuild.context.resolveElement("public", key);
        }
        InstallRepoProvider install = new InstallRepoProvider(ebuild, module);
        try {
            install.go();
        }
        catch (Exception e) {
            throw EBuildException.newProblem("Failed to install repository provider: " + e.getMessage(), e);
        }
        AbstractRepositoryProvider r = module.getRepositoryProvider();
        if (r == null) {
            throw EBuildException.newProblem("Module '" + module.key + "' does not provide a repository provider");
        }
        r.initLogger(ebuild0.logger.newSubLogger(key.name));
        r.initCredentials(ebuild0.getCredentialsFile("repo." + repoType + ".logins"));
        return r;
    }

    public InstallRepoProvider(EBuild ebuild, Module module) {
        super(ebuild);
        this.module = module;
    }

    public void go() throws Exception {
        this.go(this.module, "", Task.build_release);
    }
}

