/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.core.CPart;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.Release;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRelease
extends Release<Module>
implements IModuleRelease {
    private final CPart<Module> cpart;

    public ModuleRelease(File dir, CPart<Module> cpart) {
        super(dir);
        this.cpart = cpart;
    }

    public File getDirectory() {
        return this.getFile();
    }

    @Override
    public Collection<File> getArtifacts(Scope scope, String artifactType) {
        File export = new File(this.getFile(), scope.getName() + "/" + artifactType);
        File exportGroup = new File(this.getFile(), scope.getName() + "/" + artifactType + ".group");
        ArrayList<File> r = new ArrayList<File>();
        if (exportGroup.isDirectory()) {
            File[] files;
            for (File f : files = exportGroup.listFiles()) {
                if ("COPYRIGHT.txt".equals(f.getName())) continue;
                r.add(f);
            }
            return r;
        }
        if (export.exists()) {
            r.add(export);
        }
        return r;
    }

    @Override
    public Collection<IModuleRelease> getDependencies(Scope scope) {
        if (this.cpart != null) {
            ModuleCDependencies deps = (ModuleCDependencies)this.cpart.getDependencies();
            return deps.asCollection(scope);
        }
        return CollectionUtil.EMPTY_LIST;
    }

    public void buildClassPath(Scope scope, Collection<String> elements) {
        if (this.cpart != null && ((Module)this.cpart.part).isApi()) {
            return;
        }
        for (File f : this.getArtifacts(scope, "java.classes.jar")) {
            elements.add(f.getAbsolutePath());
        }
        if (this.cpart != null) {
            ModuleCDependencies mcdeps = (ModuleCDependencies)this.cpart.getDependencies();
            mcdeps.buildClassPath(scope, elements);
        }
    }

    public String toString() {
        return "ModuleRelease: " + this.cpart;
    }
}

