/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.CPart;
import ebuild.core.Element;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.BuildMode;
import ebuild.core.impl.Version;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Project<P extends Element> {
    protected final CPart<P> cpart;

    protected Project(CPart<P> cpart) {
        this.cpart = cpart;
    }

    public P getPart() {
        return this.cpart.part;
    }

    public ConfSet getConfiguration() {
        return this.cpart.configuration;
    }

    public ConfSet getConfigurationSelected() {
        return this.cpart.configurationSelected;
    }

    public abstract BuildMode mode();

    public CPart getCPart() {
        return this.cpart;
    }

    public String getName() {
        return ((Element)this.getPart()).getName();
    }

    public Version getVersion() {
        return ((Element)this.getPart()).getVersion();
    }

    public File getProjectFile(String path) {
        return new File(((Element)this.getPart()).getProjectDirectory(), path);
    }

    public File getSourceFile(String path) {
        return this.getProjectFile(path);
    }

    public boolean isBuilt() {
        return this.cpart.getReleaseDirectory().exists();
    }

    public String toString() {
        return this.mode().code + " " + ((Element)this.getPart()).key + " " + this.getConfiguration();
    }
}

