/*
 * Decompiled with CFR 0.152.
 */
package ebuild.xml;

import ebuild.xml.ComponentXml;
import ebuild.xml.ModuleXml;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml {
    static final String VALID_VERSIONS = "0.7";
    static Map<String, Version> map = new HashMap<String, Version>(Version.values().length + 1);
    private static Map<String, Class<? extends Xml>> ROOT_CLASSES;
    private static Serializer serializer;

    private static Version readVersion(String filename, Reader r) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xreader = factory.createXMLStreamReader(r);
        xreader.nextTag();
        String versionAttr = xreader.getAttributeValue(null, "ebuild-version");
        if (versionAttr == null) {
            throw new Exception("No 'ebuild-version' attribute defined in root element");
        }
        Version version = map.get(versionAttr);
        if (version == null) {
            throw new Exception("Unsupported format-version attribute defined in root element: " + versionAttr);
        }
        return version;
    }

    static Class<? extends Xml> rootClass(String filename, Version v) throws Exception {
        Class<? extends Xml> r = ROOT_CLASSES.get(filename);
        if (r == null) {
            throw new Exception("Unknown file: " + filename);
        }
        return r;
    }

    public static Serializer getSerializer() {
        if (serializer == null) {
            HyphenStyle style = new HyphenStyle();
            Format format = new Format(style);
            TreeStrategy strategy = new TreeStrategy("__class__", "__length__");
            serializer = new Persister((Strategy)strategy, format);
        }
        return serializer;
    }

    public static Xml deserialize(File f) throws Exception {
        Version v = Xml.readVersion(f.getName(), new FileReader(f));
        Class<? extends Xml> c = Xml.rootClass(f.getName(), v);
        Serializer serializer = Xml.getSerializer();
        return (Xml)((Object)serializer.read(c, (Reader)new FileReader(f)));
    }

    public static void serialize(Writer w, EBuildRoot obj) throws Exception {
        Serializer serializer = Xml.getSerializer();
        serializer.write((Object)obj, w);
    }

    public String toString() {
        try {
            return Xml.writeString(Xml.getSerializer(), this);
        }
        catch (Exception e) {
            return "?" + e.getMessage();
        }
    }

    public static String writeString(Serializer serializer, Object obj) throws Exception {
        StringWriter sw = new StringWriter();
        serializer.write(obj, sw);
        return sw.toString();
    }

    static {
        for (String s : VALID_VERSIONS.split(",")) {
            String k = "_" + s.replace('.', '_');
            Version v = Version.valueOf(k);
            if (v == null) {
                throw new Error("Invalid version: " + s);
            }
            map.put(s, v);
        }
        map.put("pre-1.0", Version._0_7);
        ROOT_CLASSES = new HashMap(){
            {
                this.put("module.xml", ModuleXml.EbuildModule.class);
                this.put("module-build.xml", ModuleXml.EbuildModuleBuild.class);
                this.put("build-plugin.xml", ModuleXml.EbuildBuildPlugin.class);
                this.put("component.xml", ComponentXml.EbuildComponent.class);
                this.put("component-assembly.xml", ComponentXml.EbuildComponentAssembly.class);
            }
        };
    }

    public static class Repository
    extends Xml {
        @Attribute
        public String type;
        @Attribute
        public String url;
        @Attribute
        public String org;
        @Attribute
        public String name;
    }

    public static class Property
    extends Value {
        @Attribute
        public String key;
        @Attribute(required=false)
        public String confs;
    }

    public static class Value
    extends Xml {
        @Attribute(required=false)
        private String value;
        @Text(required=false)
        private String text;

        public Object getValue() {
            return this.value != null ? this.value : (this.text != null ? this.text : null);
        }
    }

    public static class Builder
    extends Select {
        @Attribute(required=false)
        public String id;
        @Attribute(required=false)
        public String refid;
        @Attribute(required=false)
        public Boolean intermediate;
        @ElementList(empty=false, required=false, inline=true)
        public List<Property> propertiesList;

        public boolean isRefId() {
            return this.refid != null;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Configuration
    extends Xml {
        @Attribute
        public String name;
        @Attribute(required=false)
        public Boolean useInName;
        @Attribute(required=false)
        public String suffix;
        @Attribute(required=false)
        public String aliases;
    }

    public static abstract class EBuildElement
    extends EBuildRoot {
        @ElementList(required=false, empty=false)
        public List<Configuration> configurations;
    }

    public static abstract class EBuildRoot
    extends Xml {
        @Attribute
        public String ebuildVersion;
        @ElementList(empty=false, required=false)
        public List<Repository> repositories;
        @ElementList(empty=false, required=false, inline=true)
        public List<Using> usings;
    }

    public static class SelectAndMap
    extends Select {
        @Attribute(required=false)
        public String scope;
        @Attribute(required=false)
        public String confs;
        @Attribute(required=false)
        public String mapping;
        @Attribute(required=false)
        public String ivyconfs;
    }

    public static class Using
    extends Select {
        @Attribute(required=false)
        public Context context = Context.main;

        public boolean isBuild() {
            return this.context == Context.build;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Context {
            main,
            build;

        }
    }

    public static class Select
    extends Xml {
        @Attribute(required=false)
        public String source;
        @Attribute(required=false)
        public String org;
        @Attribute(required=false)
        public String name;
        @Attribute(required=false)
        public String branch;
        @Attribute(required=false)
        public String revision;
        @Attribute(required=false)
        public String version;

        public boolean isRefId() {
            return false;
        }

        public String getId() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Version {
        _0_7("0.7");

        final String string;

        private Version(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

