package ebuild.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

import ebuild.api.log.ILogger;
import ebuild.util.IOUtil;

public class AntStuff {
    
    
    static public Execution newExecution(Project p, ILogger parentLogger, String filename, Class resourceRoot) throws IOException {
        InputStream inputStream = resourceRoot.getResource(filename).openStream();
        return new Execution(p, parentLogger, filename, inputStream);
    }
    
    static public class Execution{
        final private Project p;
        final private ILogger logger; 


        
        private Execution(Project p, ILogger parentLogger, String filename, InputStream inputStream) throws IOException{
            this.p = p;
            this.logger = parentLogger.newSubLogger("ant"); 
            p.init();

            File temp = File.createTempFile(filename, "tmp");
            IOUtil.inputStreamToFile(inputStream, temp);

            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", helper);
            //p.addR
            helper.parse(p, temp);
            
            DefaultLogger consoleLogger = new DefaultLogger() {
                protected void printMessage(String msg, PrintStream stream, int priority) {
                    logger.log(msg);
                    //super.printMessage(message, stream, priority);
                }
            };
//          consoleLogger.setErrorPrintStream(System.out);
//          consoleLogger.setOutputPrintStream(System.out);
            consoleLogger.setMessageOutputLevel(Project.MSG_INFO);
            p.addBuildListener(consoleLogger);
        }
        
        public void executeTarget(String target) {
            logger.prime(); 
            p.executeTarget(target);
        }
    }


}
