/*
 * Decompiled with CFR 0.152.
 */
package ebuild.ant;

import ebuild.api.log.ILogger;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntStuff {
    public static Execution newExecution(Project p, ILogger parentLogger, String filename, Class resourceRoot) throws IOException {
        InputStream inputStream = resourceRoot.getResource(filename).openStream();
        return new Execution(p, parentLogger, filename, inputStream);
    }

    public static class Execution {
        private final Project p;
        private final ILogger logger;

        private Execution(Project p, ILogger parentLogger, String filename, InputStream inputStream) throws IOException {
            this.p = p;
            this.logger = parentLogger.newSubLogger("ant");
            p.init();
            File temp = File.createTempFile(filename, "tmp");
            IOUtil.inputStreamToFile((InputStream)inputStream, (File)temp);
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)temp);
            DefaultLogger consoleLogger = new DefaultLogger(){

                protected void printMessage(String msg, PrintStream stream, int priority) {
                    Execution.this.logger.log(msg);
                }
            };
            consoleLogger.setMessageOutputLevel(2);
            p.addBuildListener((BuildListener)consoleLogger);
        }

        public void executeTarget(String target) {
            this.logger.prime();
            this.p.executeTarget(target);
        }
    }
}

