/*
 * Decompiled with CFR 0.152.
 */
package ebuild.lib.doclet;

import com.sun.tools.javadoc.Main;
import ebuild.lib.doclet.DocExport;
import ebuild.lib.doclet.ExportDoclet;
import ebuild.util.FileUtil;
import ebuild.util.OSUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDocletRunner {
    private String sourcepath;
    private String docletpath = null;
    private String classpath = null;
    private File outDir;
    private final Set<String> donePackages = new HashSet<String>();
    private final Map<String, DocExport.Class> classDocs = new HashMap<String, DocExport.Class>();
    private static final String PATH_SEPARATOR = OSUtil.isWindows() ? ";" : ":";

    public ExportDocletRunner setOutDir(File outDir) {
        this.outDir = outDir;
        if (!outDir.isDirectory()) {
            throw new Error("Not a directory: " + FileUtil.canonicalFile((File)outDir));
        }
        return this;
    }

    private ExportDocletRunner setSourcepath(String sourcepath) {
        this.sourcepath = sourcepath;
        return this;
    }

    private ExportDocletRunner setDocletpath(String docletpath) {
        this.docletpath = docletpath;
        return this;
    }

    private ExportDocletRunner setClasspath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    private String pathAsArg(Collection<File> path) {
        return StringUtil.join((String)PATH_SEPARATOR, path);
    }

    public ExportDocletRunner setSourcepath(Collection<File> sourcepath) {
        return this.setSourcepath(this.pathAsArg(sourcepath));
    }

    public ExportDocletRunner setDocletpath(Collection<File> docletpath) {
        return this.setDocletpath(this.pathAsArg(docletpath));
    }

    public ExportDocletRunner setClasspath(Collection<File> classpath) {
        return this.setClasspath(this.pathAsArg(classpath));
    }

    public DocExport.Class getClassDoc(String packageName, String className) {
        if (!this.donePackages.contains(packageName)) {
            this.classDocs.putAll(this.execute(packageName));
            this.donePackages.add(packageName);
        }
        return this.classDocs.get(className);
    }

    public DocExport.Class expectClassDoc(String packageName, String className) {
        DocExport.Class r = this.getClassDoc(packageName, className);
        if (r == null) {
            throw new Error("No ClassDoc for: " + className);
        }
        return r;
    }

    public DocExport.Class expectClassDoc(Class c) {
        String packageName = c.getPackage().getName();
        String className = c.getName().replace('$', '.');
        return this.expectClassDoc(packageName, className);
    }

    public Map<String, DocExport.Class> execute(String ... packages) {
        File out = new File(this.outDir, packages[0]);
        ArrayList args = new ArrayList(out, packages){
            {
                if (ExportDocletRunner.this.docletpath != null) {
                    this.add("-docletpath");
                    this.add(ExportDocletRunner.this.docletpath);
                }
                if (ExportDocletRunner.this.classpath != null) {
                    this.add("-classpath");
                    this.add(ExportDocletRunner.this.classpath);
                }
                this.add("-doclet");
                this.add(ExportDoclet.class.getName());
                this.add("-sourcepath");
                this.add(ExportDocletRunner.this.sourcepath);
                this.add("-out");
                this.add(file.getAbsolutePath());
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray2[n2];
                    this.add(p);
                    ++n2;
                }
            }
        };
        System.err.println("Doclet Args");
        for (String a : args) {
            System.err.println("     " + a);
        }
        String[] argsArray = args.toArray(new String[args.size()]);
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        try {
            int r = Main.execute((String[])argsArray);
            if (r != 0) {
                throw new RuntimeException("Doclet did not succeed: " + r);
            }
        }
        finally {
            t.setContextClassLoader(cl);
        }
        try {
            ObjectInputStream oi = new ObjectInputStream(new FileInputStream(out));
            return (Map)oi.readObject();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

