/*
 * Decompiled with CFR 0.152.
 */
package ebuild.lib.remap;

import ebuild.lib.remap.RemapReport;
import ebuild.util.file.FileContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class RemappingUtil {
    public static RemapReport remapDir(Remapper remapper, File inDir, File outDir) throws IOException {
        FileContainer.Folder in = new FileContainer.Folder(inDir);
        FileContainer.Folder out = new FileContainer.Folder(outDir);
        return RemappingUtil.remap(remapper, (FileContainer)in, (FileContainer)out);
    }

    public static RemapReport remapJar(Remapper remapper, File inFile, File outFile) throws IOException {
        FileContainer.ZipRead in = new FileContainer.ZipRead((ZipFile)new JarFile(inFile));
        FileContainer.ZipWrite out = new FileContainer.ZipWrite((ZipOutputStream)new JarOutputStream(new FileOutputStream(outFile)));
        return RemappingUtil.remap(remapper, (FileContainer)in, (FileContainer)out);
    }

    public static RemapReport remap(Remapper remapper, FileContainer in, FileContainer out) throws IOException {
        RemapReport report = new RemapReport();
        for (FileContainer.Entry e0 : in.list()) {
            String name = e0.getName();
            if (!name.endsWith(".class")) continue;
            String class0 = String.valueOf(e0.getFolderPath()) + "/" + e0.getPrefix();
            String class1 = remapper.map(class0);
            byte[] d0 = e0.readBytes();
            byte[] d1 = RemappingUtil.remapEntry(remapper, e0);
            if (class0.equals(class1)) {
                byte[] d0_ = RemappingUtil.nullMap(d0);
                if (!Arrays.equals(d0_, d1)) {
                    report.shouldHaveBeenMapped.add(class0);
                    continue;
                }
                report.skipped.add(class0);
                continue;
            }
            FileContainer.Entry e1 = out.newEntry(String.valueOf(class1) + ".class");
            e1.writeBytes(d1);
            report.remapped.put(class0, class1);
        }
        out.close();
        return report;
    }

    private static byte[] nullMap(byte[] d0) {
        try {
            return RemappingUtil.remapClass(new Remapper(){}, d0);
        }
        catch (RemappingError e) {
            throw new Error(e);
        }
    }

    public static byte[] remapEntry(Remapper remapper, FileContainer.Entry e) throws IOException {
        try {
            return RemappingUtil.remapClass(remapper, e.readBytes());
        }
        catch (RemappingError re) {
            throw new Error("Unable to remap: " + e.getPath() + "\n" + re.getByteString());
        }
    }

    public static byte[] remapClass(Remapper remapper, byte[] bytecode) throws RemappingError {
        try {
            ClassReader classReader = new ClassReader(bytecode);
            ClassWriter classWriter = new ClassWriter(classReader, 0);
            classReader.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)classWriter, remapper), 0);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            throw new RemappingError(bytecode, (Throwable)e);
        }
    }

    private static String formatByteArr(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 5);
        sb.append('{');
        boolean first = true;
        byte[] byArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("" + b);
            ++n2;
        }
        sb.append('}');
        return sb.toString();
    }

    public static class RemappingError
    extends Throwable {
        final byte[] bytes;

        RemappingError(byte[] bytes) {
            this(bytes, null);
        }

        RemappingError(byte[] bytes, Throwable cause) {
            super(cause);
            this.bytes = bytes;
        }

        String getByteString() {
            return RemappingUtil.formatByteArr(this.bytes);
        }
    }
}

