package ebuild.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class IOUtil {

	static public interface ProgressListener{
		public void progress(int progress);
	}
	
	static public void pipeKeepOpen(InputStream in, OutputStream out, int buffer, ProgressListener listener) throws IOException {
		byte[] buff = new byte[16 * 1024];
		while (true) {
			int bytesRead = in.read(buff);
			if (bytesRead == -1) break;
			out.write(buff, 0, bytesRead);
			if(listener!=null) listener.progress(bytesRead);
		}
	}
	static public void pipeKeepOpen(InputStream in, OutputStream out) throws IOException {
		pipeKeepOpen(in, out, 16*1024, null);
	}
	
	static public void pipe(InputStream in, OutputStream out, int buffer, ProgressListener listener) throws IOException {
    	try{
    		pipeKeepOpen(in, out, buffer, null);
    	}finally{
    		out.close();
    	}
	}
	
	static public void pipe(InputStream in, OutputStream out) throws IOException {
		pipe(in, out, 16*1024, null);
	}
	
	static public void pipe(Reader in, Writer out) throws IOException {
    	try{
    		char[] buff = new char[16 * 1024];
    		while (true) {
    			int bytesRead = in.read(buff);
    			if (bytesRead == -1) break;
    			out.write(buff, 0, bytesRead);
    		}
    	}finally{
    		out.close();
    	}
	}
	

	static public byte[] inputStreamToBytes(InputStream is) throws IOException {
		return inputStreamToBytes(is, 32);
	}

	static public byte[] inputStreamToBytes(InputStream is, int size) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
		pipe(is, baos);
		return baos.toByteArray();
    }
	
	
	static public void stringToWriter(String s, Writer w) throws IOException{
		pipe(new StringReader(s),w);
	}
	
	static public String readerToString(Reader r) throws IOException{
		CharArrayWriter w = new CharArrayWriter();
		pipe(r,w);
		return w.toString();
	}
	
	static public String readerToString(Reader r, int length) throws IOException{
		CharArrayWriter w = new CharArrayWriter(length);
		pipe(r,w);
		return w.toString();
	}
	
	static public void bytesToFile(byte[] bytes, File f) throws IOException{
		ByteArrayInputStream in = new ByteArrayInputStream(bytes);
		inputStreamToFile(in,f);
	}
	
	static public void inputStreamToFile(InputStream in, File f) throws IOException {
		FileOutputStream out = new FileOutputStream(f);
		pipe(in,out);
	}

	
	
	static public void stringToFile(String s, File f, String charset) throws IOException{
		bytesToFile(s.getBytes(charset), f);
	}
	
	
	static public void stringToFile(String s, File f) throws IOException{
		stringToFile(s,f,"UTF-8");
	}
	

	
	static public String fileToString(File f) throws IOException{
		FileInputStream in = new FileInputStream(f);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		pipe(in,out);
		return new String(out.toByteArray(),"UTF-8");
	}

	static public String resourceToString(Class class_, String resource) throws IOException {
        InputStreamReader ir = new InputStreamReader(class_.getResource(resource).openStream());
	    return readerToString(ir);
    }
	
	static public String resourceToStringSafe(Class class_, String resource) {
		try{
	        InputStreamReader ir = new InputStreamReader(class_.getResource(resource).openStream());
		    return readerToString(ir);
		}catch(IOException e){
			throw new Error(e);
		}
    }
}
