package ebuild.util;

public class ObjectUtil {
    static public<O> O coalesce(O... os){
        for(O o: os){
            if(o!=null) return o;
        }
        return null;
    }
    static public int coalesce(int... os){
        for(int o: os){
            if(o!=0) return o;
        }
        return 0;
    }
    static public boolean areEqual(Object a, Object b) {
        if(a==null && b==null) return true;
        if(a==null || b==null) return false;
        return a.equals(b);
    }
    static public String asString(Object o) {
        if(o==null) return null; 
        return o.toString();
    }
    static public void notNull(Object o) {
        if(o==null) throw new NullPointerException();
    }
    static public int hashOf(Object o){
        if(o==null) return 0;
        return o.hashCode();
    }
}
