/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final CopyFilter COPYFILTER_ALL = new CopyFilter(){

        public boolean accept(File source, File dest) {
            return true;
        }
    };
    public static final CopyFilter COPYFILTER_IFNEWER = new CopyFilter(){

        public boolean accept(File source, File dest) {
            if (source.isDirectory()) {
                return true;
            }
            return dest.lastModified() >= source.lastModified();
        }
    };
    private static final FileFilter ACCEPT_ALL = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };

    public static boolean fileExists(File dir, String name) {
        return new File(dir, name).isFile();
    }

    public static boolean hasFile(File dir, final FileFilter filter) throws Exception {
        return (Boolean)new Traversal(){
            boolean found = false;

            public void onFile(File f) {
                if (filter.accept(f)) {
                    this.found = true;
                    this.exit = true;
                }
            }

            public Object finish() {
                return this.found;
            }
        }.go(dir);
    }

    public static boolean hasFileWithSuffix(File dir, final String suffix) throws Exception {
        return FileUtil.hasFile(dir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(suffix);
            }
        });
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String relativePath(File ancestor, File f) {
        String path = f.getName();
        File p = f;
        while (!(p = p.getParentFile()).equals(ancestor)) {
            path = p.getName() + "/" + path;
        }
        return path;
    }

    public static String fileSuffix(File f) {
        return FileUtil.fileSuffix(f.getName());
    }

    public static String fileSuffix(String name) {
        int dot = name.indexOf(46);
        if (dot == -1) {
            return null;
        }
        return name.substring(dot + 1);
    }

    public static String replaceSuffix(String name, String suffix) {
        name = FileUtil.removeSuffix(name) + "." + suffix;
        return name;
    }

    public static String removeSuffix(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return name;
        }
        name = name.substring(0, dot);
        return name;
    }

    public static File copyToDirIfNewer(File f, File dir) throws IOException {
        File r = new File(dir, f.getName());
        FileUtil.copyIfNewer(f, r);
        return r;
    }

    public static File copyToDir(File f, File dir) throws IOException {
        File r = new File(dir, f.getName());
        FileUtil.copy(f, r);
        return r;
    }

    public static void copyFileIfNewer(File source, File dest) throws IOException {
        if (COPYFILTER_IFNEWER.accept(source, dest)) {
            return;
        }
        FileUtil.doCopyFile(source, dest);
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileUtil.doCopyFile(source, dest);
    }

    public static void copyIfNewer(File source, File dest) throws IOException {
        FileUtil.copy(source, dest, COPYFILTER_IFNEWER);
    }

    public static void copy(File source, File dest) throws IOException {
        FileUtil.copy(source, dest, COPYFILTER_ALL);
    }

    public static File createTempDirectory(String name) throws IOException {
        File r = File.createTempFile("", "tmp");
        r.delete();
        r.mkdirs();
        return r;
    }

    public static void copy(File source, File dest, CopyFilter filter) throws IOException {
        if (!filter.accept(source, dest)) {
            return;
        }
        if (source.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (File source2 : source.listFiles()) {
                FileUtil.copy(source2, new File(dest, source2.getName()), filter);
            }
        } else {
            if (!source.exists()) {
                throw new IOException("File or directory does not exist: " + source);
            }
            FileUtil.doCopyFile(source, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File source, File dest) throws IOException {
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            dest.getParentFile().mkdirs();
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = ((FileChannel)in).size();
            MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static long deepLastModified(File root) {
        return (Long)new Traversal<Long, RuntimeException>(){
            long lastModified = Long.MIN_VALUE;

            @Override
            public void onFile(File f) {
                this.lastModified = Math.max(this.lastModified, f.lastModified());
            }

            @Override
            protected void onDirectory(File d) {
                this.lastModified = Math.max(this.lastModified, d.lastModified());
            }

            @Override
            public Long finish() {
                return this.lastModified;
            }
        }.go(root);
    }

    public static long lastModified(Collection<File> files) {
        long r = 0L;
        for (File f : files) {
            r = Math.max(r, f.lastModified());
        }
        return r;
    }

    public static Collection<String> deepList(File f) {
        ArrayList<String> r = new ArrayList<String>();
        for (File f2 : f.listFiles()) {
            FileUtil.deepList_(r, f2.getName(), f2);
        }
        return r;
    }

    private static void deepList_(Collection<String> r, String path, File f) {
        if (f.isDirectory()) {
            r.add(path + "/");
            for (File f2 : f.listFiles()) {
                String path2 = path + "/" + f2.getName();
                FileUtil.deepList_(r, path2, f2);
            }
        } else {
            r.add(path);
        }
    }

    public static File canonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }

    public static void deleteOrFail(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException("Unable to delete file: " + f.getAbsolutePath());
        }
    }

    private static void zip(File x, String path, ZipOutputStream z, FileFilter filter) throws IOException {
        if (!filter.accept(x)) {
            return;
        }
        if (!x.exists()) {
            throw new IOException("File not found: " + x);
        }
        if (!x.isDirectory()) {
            z.putNextEntry(new ZipEntry(path + "/" + x.getName()));
            FileInputStream y = new FileInputStream(x);
            IOUtil.pipeKeepOpen(y, z);
            z.closeEntry();
            y.close();
        } else {
            path = path + "/";
            FileUtil.zipDir(x, path + x.getName(), z, filter);
        }
    }

    private static void zipDir(File x, String path, ZipOutputStream z, FileFilter filter) throws IOException {
        for (File x2 : x.listFiles()) {
            FileUtil.zip(x2, path, z, filter);
        }
    }

    public static void zipDirectories(File archive, List<File> dirs) throws IOException {
        FileUtil.zipDirectories(archive, dirs, ACCEPT_ALL);
    }

    public static void zipDirectories(File archive, List<File> dirs, FileFilter filter) throws IOException {
        ZipOutputStream z = new ZipOutputStream(new FileOutputStream(archive));
        for (File dir : dirs) {
            FileUtil.zipDir(dir, "", z, filter);
        }
        z.close();
    }

    public static void zipDirectoryIncludeName(File archive, File dir) throws IOException {
        FileUtil.zipDirectoryIncludeName(archive, dir, ACCEPT_ALL);
    }

    public static void zipDirectoryIncludeName(File archive, File dir, FileFilter filter) throws IOException {
        ZipOutputStream z = new ZipOutputStream(new FileOutputStream(archive));
        FileUtil.zipDir(dir, dir.getName(), z, filter);
        z.close();
    }

    public static interface CopyFilter {
        public boolean accept(File var1, File var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Traversal<R, E extends Exception> {
        protected boolean exit = false;

        public final void traverse(File f) throws E {
            if (this.exit) {
                return;
            }
            if (f.isDirectory()) {
                File[] childs;
                if (f.getName().startsWith(".")) {
                    return;
                }
                this.onDirectory(f);
                for (File child : childs = f.listFiles()) {
                    this.traverse(child);
                }
                return;
            }
            this.onFile(f);
        }

        protected void onDirectory(File d) {
        }

        protected void onFile(File f) throws E {
        }

        public R go(File f) throws E {
            if (f.exists()) {
                this.traverse(f);
            }
            return this.finish();
        }

        public R finish() {
            return null;
        }
    }
}

