/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static final Object[] EMPTYARRAY = new Object[0];
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;
    public static final Set EMPTY_SET = Collections.EMPTY_SET;
    public static final Map EMPTY_MAP = Collections.EMPTY_MAP;
    public static final Iterator EMPTY_ITERATOR = EMPTY_SET.iterator();
    public static Filter ACCEPT_ALL = new Filter(){

        public boolean accept(Object object) {
            return true;
        }
    };

    public static <V> Iterator<V> singletonIterator(V obj) {
        return CollectionUtil.singletonSet(obj).iterator();
    }

    public static <V> List<V> singletonList(V obj) {
        return Collections.singletonList(obj);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return Collections.singletonMap(k, v);
    }

    public static <V> Set<V> singletonSet(V obj) {
        return Collections.singleton(obj);
    }

    public static <V> Iterator<V> arrayIterator(V[] types) {
        return Arrays.asList(types).iterator();
    }

    public static <V> Set<V> newSet(V ... vs) {
        HashSet<V> r = new HashSet<V>(vs.length);
        for (V v : vs) {
            r.add(v);
        }
        return r;
    }

    public static <V> List<V> newList(V ... vs) {
        ArrayList<V> r = new ArrayList<V>(vs.length);
        for (V v : vs) {
            r.add(v);
        }
        return r;
    }

    public static <O> void filter(Collection<O> col, Filter<O> f) {
        Iterator<O> I = col.iterator();
        while (I.hasNext()) {
            O o = I.next();
            if (f.accept(o)) continue;
            I.remove();
        }
    }

    public static Map newMap(Object ... args) {
        if (args.length % 2 != 0) {
            throw new RuntimeException("!");
        }
        HashMap<Object, Object> r = new HashMap<Object, Object>(args.length);
        for (int i = 0; i < args.length; i += 2) {
            r.put(args[i], args[i + 1]);
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<O> {
        public boolean accept(O var1);
    }
}

